/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "OSAW.h"

using namespace Martini::OSA;

CReadOnlyFileMapping::CReadOnlyFileMapping()
{
    m_hFile                  = INVALID_HANDLE_VALUE;
    m_hFileMapping           = INVALID_HANDLE_VALUE;
    m_pMappedFileBaseAddress = 0;
    m_uiLength               = 0;
}

TResult CReadOnlyFileMapping::Open(const char *szFileName)
{
    if(szFileName == 0)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }

    m_hFile = CreateFile(szFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL, NULL);
    
    if (m_hFile == INVALID_HANDLE_VALUE)
    {
        return MRTE_ERROR_INVALID_HANDLE;
    }

    m_uiLength = GetFileSize(m_hFile, NULL);

    if (m_uiLength == INVALID_FILE_SIZE)
    {
        // close the handle and nullify it
    	CloseHandle(m_hFile);
        m_hFile = INVALID_HANDLE_VALUE;
        return MRTE_ERROR_FILE_FAILURE;
    }

    // create mapping object for the whole file
    m_hFileMapping = CreateFileMapping(m_hFile, NULL, PAGE_READONLY, 0, 0, NULL);

    if (m_hFileMapping == 0)
    {
        // close the handle and nullify it
        CloseHandle(m_hFile);
        m_hFile = INVALID_HANDLE_VALUE;
        return MRTE_ERROR_INVALID_HANDLE;
    }
    
    // map the whole file into memory
    m_pMappedFileBaseAddress = MapViewOfFile(m_hFileMapping, FILE_MAP_READ, 0, 0, 0);
    
    if (! m_pMappedFileBaseAddress)
    {
        // close handles and nullify them
        CloseHandle(m_hFileMapping);
        m_hFileMapping = 0;
        CloseHandle(m_hFile);
        m_hFile = INVALID_HANDLE_VALUE;
        return MRTE_ERROR_MEMORY_MAP_FAIL;
    }

    return MRTE_RESULT_OK;
}

TResult CReadOnlyFileMapping::Destroy()
{
    if(m_pMappedFileBaseAddress)
    {
        UnmapViewOfFile(m_pMappedFileBaseAddress);
    }
    
    if (m_hFileMapping != 0)
    {
        CloseHandle(m_hFileMapping);
    }

    if (m_hFile != INVALID_HANDLE_VALUE)
    {
        CloseHandle(m_hFile);
    }
    
    delete this;
    return MRTE_RESULT_OK;
}

CReadOnlyFileMapping::~CReadOnlyFileMapping()
{
}
