/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "OSAW.h"

Martini::OSA::CThreadLocalStorage::CThreadLocalStorage()
{
}

Martini::OSA::CThreadLocalStorage::~CThreadLocalStorage()
{
	TlsFree(m_dwTlsIndex);
}


void* Martini::OSA::CThreadLocalStorage::GetValue()
{
    return TlsGetValue(m_dwTlsIndex);
}

void Martini::OSA::CThreadLocalStorage::SetValue(void* pValue)
{
	TlsSetValue(m_dwTlsIndex, pValue);
}

TResult Martini::OSA::CThreadLocalStorage::Destroy()
{
    delete this;
    return MRTE_RESULT_OK;
}


TResult Martini::OSA::CThreadLocalStorage::Create()
{
    m_dwTlsIndex = TlsAlloc();

    if(m_dwTlsIndex == TLS_OUT_OF_INDEXES) 
    {
        return MRTE_RESULT_FALSE;
    }
    return MRTE_RESULT_OK;
}

