/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifdef EM64T_ARCH
#pragma runtime_checks( "", off )
#endif

#include "OSAW.h"


Martini::OSA::CThreadSync::CThreadSync()
{
}

Martini::OSA::CThreadSync::~CThreadSync()
{
	DeleteCriticalSection(&m_csSync);
}


TResult Martini::OSA::CThreadSync::Enter()
{
	EnterCriticalSection(&m_csSync);
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CThreadSync::Leave()
{
	LeaveCriticalSection(&m_csSync);
    return MRTE_RESULT_OK;
}

TResult Martini::OSA::CThreadSync::TryEnter()
{
//    Not supported in the compiler we use
//    BOOL bLocked = TryEnterCriticalSection(&m_csSync);
//    if (bLocked == FALSE)
//    {
//        return MRTE_RESULT_FALSE;
//    }
//    return MRTE_RESULT_OK;
    return MRTE_RESULT_NOT_IMPLEMENTED;
}

TResult Martini::OSA::CThreadSync::Destroy()
{
    delete this;
    return MRTE_RESULT_OK;
}


TResult Martini::OSA::CThreadSync::Create()
{
    try
    {
        InitializeCriticalSection(&m_csSync);
    }
    catch (DWORD dwExc) 
    {
        if (dwExc == STATUS_NO_MEMORY)
        {
            return MRTE_ERROR_OUT_OF_MEMORY;
        }
    }
    return MRTE_RESULT_OK;
}

