/*****************************************************************************
 * Copyright (c) 1997, 2010, Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: LibraryLoader.cpp,v 1.3 2010/09/08 15:20:46 mreid Exp $ 
 *****************************************************************************/

#include <dlfcn.h>
#include "OSAL.h"
#include <unistd.h>
#include <errno.h>
#include <sys/resource.h>


Martini::OSA::CLibraryLoader::CLibraryLoader()
{
}

Martini::OSA::CLibraryLoader::~CLibraryLoader()
{
}

void* Martini::OSA::CLibraryLoader::GetEntry(char *szEntryName)
{
    return dlsym(m_vpLibrary, szEntryName);
}


TResult Martini::OSA::CLibraryLoader::Destroy()
{   
    delete this;
    return MRTE_RESULT_OK;
}

static void CheckIfLibraryIsLoaded(const char *szLibName, char *LibPathBuff);

TResult Martini::OSA::CLibraryLoader::Create(const char *szLibName, const char *szLibPath, bool bLoadOnce) 
{   
    char szLoadedDllFullPath[MAX_PATH], szLoadedLibPath[MAX_PATH];
    szLoadedDllFullPath[0] = 0;	
    
    if (szLibName == NULL)
    {
        return MRTE_ERROR_ILLEGAL_ARGUMENT;
    }
    if (bLoadOnce)
    {
        CheckIfLibraryIsLoaded(szLibName,szLoadedLibPath);
        if (!(strcmp(szLoadedLibPath,"Err")))
        {
                return MRTE_ERROR_ILLEGAL_ARGUMENT;
        }
        else if (!(strcmp(szLoadedLibPath,"NULL")))
        {
            bLoadOnce = false;
        }
        else
        {
            strcpy(szLoadedDllFullPath,szLoadedLibPath); 
        }
        
    }
    if (!bLoadOnce)
    {
        if ((szLibPath != NULL) && (szLibPath[0] != '\0')) 
        {
	        // Bug 317863: Add szLibPath to the LIBPATH env var (if it isn't already there)
	        unsigned int libPathEnvLen = MAX_PATH;
	        char* libPathEnv = new char[libPathEnvLen+1];
	        
	        int ret = GetEnvironmentVar("LIBPATH", libPathEnv, libPathEnvLen, &libPathEnvLen);
	        if( MRTE_ERROR_BUFFER_TOO_SHORT == ret )
	        {
		        delete []libPathEnv; libPathEnv = new char[ libPathEnvLen + 1 ];

		        ret = GetEnvironmentVar("LIBPATH", libPathEnv, libPathEnvLen, &libPathEnvLen);
		        if( MRTE_FAILED(ret) )
		        {
			        delete []libPathEnv;
			        return MRTE_ERROR_LIBRARY_FAILURE;
		        }
	        }
	        
	        // Prepend szLibPath if we obtained the current LIBPATH successfully and
	        // szLibPath is not already in LIBPATH
	        if( MRTE_RESULT_OK == ret
	            && NULL == strstr(libPathEnv, szLibPath) )
	        {
		        char* newLibPath =  new char[ libPathEnvLen + strlen(szLibPath) + 2 ];
		        strcpy(newLibPath, szLibPath);
		        strcat(newLibPath, ":");
		        strcat(newLibPath, libPathEnv);

		        SetEnvironmentVar("LIBPATH", newLibPath);
		        delete []newLibPath;
	        }
	        else if( MRTE_RESULT_FALSE == ret ) 
	        {
		        // LIBPATH env currently not set, so let's set it
		        SetEnvironmentVar("LIBPATH", const_cast<char*>(szLibPath));
	        }
	        delete []libPathEnv;

            strcat(szLoadedDllFullPath, szLibPath);
			strcat(szLoadedDllFullPath, "/");
        }

		strcat(szLoadedDllFullPath, "lib");
		strcat(szLoadedDllFullPath, szLibName);
		strcat(szLoadedDllFullPath, ".so");
    }

    m_vpLibrary = dlopen(szLoadedDllFullPath, RTLD_LAZY);
    if (m_vpLibrary == NULL) 
    {
    //    fprintf(stderr,"dll %s failed to load: %s\n",szLoadedDllFullPath,dlerror());
        return MRTE_ERROR_LIBRARY_FAILURE;
    }
//    fprintf(stderr,"dll %s loaded\n",szLoadedDllFullPath);
    return MRTE_RESULT_OK;
}


static void CheckIfLibraryIsLoaded(const char *szLibName, char *LibPathBuff)
{

    FILE *f;
    char linebuf[MAX_PATH];
    U64 st=0, en=0, len;
    int dunno, cu = 0, i, j=0, p_id;
    char flags[32], indev[32], path[MAX_PATH];
    char szTempLibName[MAX_PATH], FileName[MAX_PATH];


    p_id=getpid();
	if(-1 == getpriority(PRIO_PROCESS, p_id) && errno != 0) {
		strcpy(LibPathBuff,"Err");
	    return;
	}
	//else
		// to do on MVS
/*
    while(!feof(f))
    {
        if(!fgets(linebuf, sizeof linebuf, f))
        {
            break;
        }
        // only the path data is relevant. all the other vars (st, en, flags...) are for parsing.
        if(sscanf(linebuf, "%lx-%lx %s %8lx %s %ld %s\n", &st, &en, flags, &len, indev, &dunno, path) < 5) 
        {
            break;
        }
        cu++;
        i=strlen(path);
        while ((i>0) && (path[i]!='/'))
        {
            i--;
        }    
        i++;
        if ((path[i]=='l') && (path[i+1]=='i') && (path[i+2]=='b'))
        {
            i+=3;
        }
        while (!((path[i]=='.') && (path[i+1]=='s') && (path[i+2]=='o')) && (i < strlen(path)))
        {
            szTempLibName[j++]=path[i++];
        }
        szTempLibName[j]='\0';
        j=0;
        if (!strcmp(szLibName,szTempLibName))
        {
            strcpy(LibPathBuff,path);
            return ;
        }
    }
    */
    strcpy(LibPathBuff,"NULL");
    return ;
            
}
