/*****************************************************************************
 * Copyright (c) 1997, 2009, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: OSAL.h,v 1.1 2009/08/26 15:21:08 jwest Exp $ 
 *****************************************************************************/

#ifndef __OSAL32_H__
#define __OSAL32_H__

#include "OSA.h"
#include <dlfcn.h>

#include <rpc/types.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>

#include <pthread.h>
#include <fcntl.h>


#define INVALID_HANDLE_VALUE -1
#define INVALID_FILE_SIZE -1 

namespace Martini { namespace OSA
{            
    class CReadOnlyFileMapping : public IReadOnlyFileMapping  
    {
    public:			
        virtual void* GetBaseAddress() 
        {
            return m_pMappedFileBaseAddress;
        };
        virtual unsigned int GetLength() 
        {
            return m_uiLength;
        };
        
        virtual TResult Destroy();
    protected:    
        CReadOnlyFileMapping();
        virtual ~CReadOnlyFileMapping();
        virtual TResult Open(const char *szFileName);
        unsigned int GetFileSize(int iFileDesc);
        
        int             m_iFileDesc;
        void*           m_pMappedFileBaseAddress;
        unsigned int    m_uiLength;
        
        friend OSA_EXPORT IReadOnlyFileMapping *CreateReadOnlyFileMapping(const char *szFileName);
    };
    
    
    class CDirectoryHandle : IDirectoryHandle
    {
    public:
        virtual TResult GetNextFileName(bool* pbIsDirectory, char* szFileName, 
            unsigned int uiNumOfBytesToWrite,
            unsigned int *puiNumOfBytesNeeded);
        
        virtual const char* GetName();
        
        virtual TResult Destroy();
    protected:
        CDirectoryHandle();
        virtual ~CDirectoryHandle();
        
        virtual TResult Open(const char *cszDirectoryName);
        friend OSA_EXPORT IDirectoryHandle *CreateDirectoryHandle(const char *cszDirName);
        
        DIR*   m_hDirectory;
        char*  m_szDirectoryName;
    };
    
    
    class CLibraryLoader : public ILibraryLoader
    {
    public:
        virtual void *GetEntry(char *szEntryName);
        
        virtual TResult Destroy();
    protected:
        CLibraryLoader();
        virtual ~CLibraryLoader();
        
        virtual TResult Create(const char *szLibName, const char *szLibPath, bool bLoadOnce);
        
        void *m_vpLibrary;
        
        friend OSA_EXPORT ILibraryLoader *CreateLibraryLoader(const char *szLibName, 
            const char *szLibPath, bool bLoadOnce);
    };
    
    class CThreadSync : public IThreadSync  
    {
    public:
        virtual TResult Enter();
        virtual TResult Leave();
        virtual TResult TryEnter();
        
        virtual TResult Destroy();
    protected:
        CThreadSync();
        virtual ~CThreadSync();
        
        virtual TResult Create();
    protected:
        pthread_mutex_t m_pthreadSync;
        
        friend OSA_EXPORT IThreadSync *CreateThreadSync();
    };
    
    class CThreadLocalStorage : public IThreadLocalStorage
    {
        virtual void* GetValue();
        
        virtual void SetValue(void* pValue);
        
        virtual TResult Destroy();
    protected:
        CThreadLocalStorage();
        virtual ~CThreadLocalStorage();
        
        virtual TResult Create();
        
        pthread_key_t m_tlsIndex;
        
        friend OSA_EXPORT IThreadLocalStorage *CreateThreadLocalStorage();
    };
    
}} // namespace 
        
#endif

