/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: ThreadProxy.java,v 1.3 2010/05/11 16:32:22 jwest Exp $ 
 *****************************************************************************/
package org.eclipse.tptp.martini;

public class ThreadProxy {
	
	//---------------------------------------
	//take care to hold it synced with 
	//callIDs:
	private static final int TI_NOTIFY_ALL = 1; 
	private static final int TI_NOTIFY = 2; 
	private static final int TI_INTERRUPT = 3; 
	private static final int TI_START = 4;
	
	private static final int TI_SLEEP_BEGIN = 5; 
	private static final int TI_SLEEP_END = 6; 
	
	
	private static int m_bJVMInit = 0;
	private static int m_bEventsEnabled = 0;

	public static int IsJVMInit()
	{
		return m_bJVMInit;
	}
	
	public static void JVMInit()
	{
		m_bJVMInit = 1;
	}
	
	public static void SetEventsStatus(int status)
	{
		m_bEventsEnabled = status;
	}

	//TODO: use javadoc 
	//----------------------------------------------------- 
	//Hook for notify and notifyAll methods of class Object
	public static void earlyCallNotify(Object obj) {
		if (m_bEventsEnabled == 1) {
			callThreadInteraction(obj, TI_NOTIFY);
		}
	}
	
	public static void earlyCallNotifyAll(Object obj) {
		if (m_bEventsEnabled == 1) {
			callThreadInteraction(obj, TI_NOTIFY_ALL);
		}
	}
	//-----------------------------------------
	//Hook for interrupt method of class Thread
	public static void earlyCallInterrupt(Object obj) {
		if (m_bEventsEnabled == 1) {
			if (obj instanceof Thread) {
				if (((Thread)obj).getState() == Thread.State.TIMED_WAITING ||
					((Thread)obj).getState() == Thread.State.WAITING) {
					callThreadInteraction(obj, TI_INTERRUPT);
				}
			}
		}
	}
	
	//------------------------------------- 
	//Hook for start method of class Thread
	public static void earlyCallStart(Object obj) {
		if (m_bEventsEnabled == 1) {
			if (obj instanceof Thread) {
				callThreadInteraction(obj, TI_START);
			}
		}
	}
	
	//------------------------------------- 
	//Hook for start method of Thread.sleep() call
	public static void earlySleepStart() {
		if (m_bEventsEnabled == 1) {
			callThreadInteraction(Thread.currentThread(), TI_SLEEP_BEGIN);
		}
	}	

	//------------------------------------- 
	//Hook for method of post-Thread.sleep() call
	public static void earlySleepEnd() {
		if (m_bEventsEnabled == 1) {
			callThreadInteraction(Thread.currentThread(), TI_SLEEP_END);
		}
	}	

	//-----------------------------------
	//Native method pass notification to Martini
	public static native void callThreadInteraction(Object obj, int callID);
}
