/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#include "IdAllocator.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

using namespace Martini::Infrastructure;
using namespace Martini::OSA;

CIdAllocator::CIdAllocator()
{
    m_pThreadSync = CreateThreadSync();
    m_uiNextId = 1;
}

CIdAllocator::CIdAllocator(unsigned int uiFirstId)
{
    m_pThreadSync = CreateThreadSync();
    m_uiNextId = uiFirstId;
}

CIdAllocator::~CIdAllocator()
{
    m_pThreadSync->Destroy();
}

unsigned int CIdAllocator::AllocateId()
{
    m_pThreadSync->Enter();
    unsigned int uiRetVal = m_uiNextId++;
    m_pThreadSync->Leave();

    return uiRetVal;
}

// allocated ids are [uiRetVal - (uiRetVal+uiNumIds-1)]
unsigned int CIdAllocator::AllocateIds(unsigned int uiNumIds)
{
    m_pThreadSync->Enter();
    unsigned int uiRetVal = m_uiNextId;
    m_uiNextId += uiNumIds;
    m_pThreadSync->Leave();

    return uiRetVal;
}


