/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/
//

#include <string.h>

#include "WideStringUtils.h"

using namespace Martini::MIE;

//////////////////////////////////////////////////////////////////////////
// class CWideStringUtils implementation

// constructor
CWideStringUtils::CWideStringUtils()
{

}

void CWideStringUtils::InitWideString(SWideString &ws, const char *sz)
{
    unsigned int cbsz = strlen(sz);
    ws.uiBufferSize = cbsz;
    ws.uiActualSize = cbsz;
    ws.pStr = new unsigned short[cbsz];
    for (size_t i = 0; i < cbsz; ++i)
    {
        ws.pStr[i] = sz[i];
    }
}

char* CWideStringUtils::WideStringToCString(const SWideString &ws)
{
    unsigned int cbwz = ws.uiActualSize;
    char *szResult = new char[cbwz + 1];
    if (NULL == szResult)
    {
        return NULL;
    }
    for (size_t i = 0; i < cbwz; ++i)
    {
        szResult[i] = static_cast<unsigned char>(ws.pStr[i]);
    }
    // add the terminating NULL to the C-String
    szResult[cbwz] = 0;
    return szResult;
}

void CWideStringUtils::FreeWideString(const SWideString &ws)
{
    delete [] ws.pStr;
}

void CWideStringUtils::AllocateWideString(SWideString &ws, unsigned int length)
{
    ws.uiActualSize = length;
    ws.uiBufferSize = length;
    ws.pStr = new unsigned short[length];
}

void CWideStringUtils::AssignText(SWideString &ws, const char *szText)
{
    size_t cbText = strlen(szText);
    for (size_t i = 0; i < cbText; ++i)
    {
        ws.pStr[i] = szText[i];
    }
}

void CWideStringUtils::ReallocateWideString(SWideString &ws)
{
    if (ws.uiActualSize == ws.uiBufferSize)
    {
        return;
    }
    if (ws.uiActualSize < ws.uiBufferSize)
    {
        return;
    }
    // reallocate the string to its actual size
    delete [] ws.pStr;
    ws.pStr = new unsigned short[ws.uiActualSize];
    ws.uiBufferSize = ws.uiActualSize;

}

