/************************************************************************
 * Copyright (c) 2007, 2010 OC Systems Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#include "ClassFileLoadHookEvent.h"
#include "InstrumenterFactory.h"
#include "Instrumenter.h"

using namespace Martini::ProbekitAgent;
using namespace Martini::MPI;

/*
 * CClassFileLoadHookEvent
 */ 

CClassFileLoadHookEvent::CClassFileLoadHookEvent(){}

CClassFileLoadHookEvent::~CClassFileLoadHookEvent(){}

/*
 * Init	- initializes internal data and registers event
 */
TResult CClassFileLoadHookEvent::Init(IMpi *pMpiApi, TId clientId)
{
	m_pMpiApi	=	pMpiApi;
	m_clientId	=	clientId;

	// Register event
	TResult res;
    res = m_pMpiApi->RegisterEvent(m_clientId, *this);

	return res;
}

/*
 * HandleEvent - callback function for Class File Load Hook event
 */

    // Here the agent can instrument the class.
    // Class data is stored in the 'data' argument.

    // If the agent instrumented the class, it needs to allocate a new buffer in
    // newClassData using memAllocFunc, and then set the new class data length in
    // newClassDataLength.
    
    // If the agent did not instrument the class, it should leave newClassData untouched,

void CClassFileLoadHookEvent::HandleEvent(SClassFileLoadHookEventData &data, 
                                          TMemoryAllocatorFunc memAllocFunc, 
                                          unsigned char **newClassData, 
                                          S32 *newClassDataLength)
{
	CInstrumenterFactory::getInstrumenter()->Instrument( 
			memAllocFunc,
			data.className,
			(const char*)data.classData, 
        	data.classDataLength,
        	(char**)newClassData, 
			newClassDataLength );
}



