/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/

#ifndef PROBEKIT_CLASS_FILE_LOAD_HOOK_EVENT_H
#define PROBEKIT_CLASS_FILE_LOAD_HOOK_EVENT_H

#include "MpiAPI.h"

namespace Martini { namespace ProbekitAgent {

	// CClassFileLoadHookEvent - represents a Class File Load Hook event
	class CClassFileLoadHookEvent : public MPI::IJavaClassFileLoadHookEventObserver
	{
	public:
		CClassFileLoadHookEvent();
		~CClassFileLoadHookEvent();

        // Initialization - Register to event
		TResult Init(MPI::IMpi *pMpiApi, MPI::TId clientId);
        
        // Event handler
        void HandleEvent(MPI::SClassFileLoadHookEventData &data,
                         TMemoryAllocatorFunc memAllocFunc,
                         unsigned char **newClassData,
                         S32 *newClassDataLength);

	private:
		// Pointer to the MPI implementation
        MPI::IMpi *m_pMpiApi;

        // Client id for MPI requests
	    MPI::TId m_clientId;
	};

} /*namespace Martini*/  } /*namespace ProbekitAgent*/

#endif	// PROBEKIT_CLASS_FILE_LOAD_HOOK_EVENT_H

