 /********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * 
 * Contributors: 
 * Raheel Ashraf
 * IBM - Initial API and implementation 
 **********************************************************************/ 


#include "ECCustomEvent.h"
#include "Globals.h"
#include <log.h>

using namespace Martini::ProbekitAgent;
using namespace Martini::MPI;

CECCustomEvent::CECCustomEvent(){}

CECCustomEvent::~CECCustomEvent(){}

/*
 * Init	- initializes internal data and registers for VM init event	
 */
TResult CECCustomEvent::Init(IMpi *pMpiApi, TId clientId)
{ 
	TResult res = pMpiApi->RegisterEvent(clientId, *this);
	return res;
}

/*
 * HandleEvent - callback function 
 */
void CECCustomEvent::HandleEvent(SCustomCommandEventData &data)
{
	//JPIAgent::ENABLE_DATA_COLLECTION
	if(data.commandId == JPIAgent::ENABLE_DATA_COLLECTION) {
		LOG_TRACE("Data Collection Enabled - Calling On Attached");	
		CInstrumenterFactory::getInstrumenter()->OnDataCollectionEnabled();
		// TODO remove the listener once we have seen the event
	}
			
	LOG_TRACE( PROFILER_NAME " EC Custom" );
}
