/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/

#include "ECStartEvent.h"
#include "Globals.h"
#include <log.h>

using namespace Martini;
using namespace Martini::MPI;
using namespace Martini::ProbekitAgent;

CECStartEvent::CECStartEvent(){}
CECStartEvent::~CECStartEvent(){}

/*
 * Init - initializes internal data and registers for Start event    
 */
TResult 
CECStartEvent::Init(MPI::IMpi *pMpiApi, MPI::TId clientId)
{
    TResult res = pMpiApi->RegisterEvent(clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for Start event    
 */
void 
CECStartEvent::HandleEvent()
{
	LOG_TRACE( PROFILER_NAME " EC Start" );
}
