/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/

#include "ECStopEvent.h"
#include "Globals.h"
#include <log.h>

using namespace Martini;
using namespace Martini::MPI;
using namespace Martini::ProbekitAgent;

CECStopEvent::CECStopEvent(){}
CECStopEvent::~CECStopEvent(){}

/*
 * Init - initializes internal data and registers for Stop event    
 */
TResult 
CECStopEvent::Init(MPI::IMpi *pMpiApi, MPI::TId clientId)
{
    TResult res = pMpiApi->RegisterEvent(clientId, *this);
    return res;
}

/*
 * HandleEvent - callback function for Stop event    
 */
void 
CECStopEvent::HandleEvent()
{
	LOG_TRACE( PROFILER_NAME " EC Stop" );
}
