/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#ifndef PROBEKIT_GLOBALS_H
#define PROBEKIT_GLOBALS_H

#include "JPI.H"

#define PROFILER_NAME "PROBEKIT"

namespace Martini { namespace ProbekitAgent {

    class CGlobals
    {
    public:
        static CGlobals* Instance() 
        {
            if (0 == s_pInstance)
            {
                s_pInstance = new CGlobals();
            }
            return s_pInstance;
        }

        TJpiAttachCurrentThread pfnJPI_AttachCurrentThread;
        TJpiDetachCurrentThread pfnJPI_DetachCurrentThread;
        
        bool m_VMInitSeen;

    protected:
        static CGlobals* s_pInstance;

        CGlobals(): 
            pfnJPI_AttachCurrentThread(0), pfnJPI_DetachCurrentThread(0),
            m_VMInitSeen(false)
            {}

    };
}}
#endif // PROBEKIT_GLOBALS_H

