/************************************************************************
 * Copyright (c) 2007, 2010 OC Systems Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#ifndef PROBEKIT_INSTRUMENTER_H
#define PROBEKIT_INSTRUMENTER_H

#ifdef MVS
	#include <stddef.h>
#endif

#include <stdlib.h>
#include <MRTEResults.h>
#include <MRTETypes.h>

namespace Martini { namespace ProbekitAgent {
                                  
class IInstrumenter       
{
public:

    typedef void* (*TMemoryAllocatorFunc)(unsigned int);

    virtual ~IInstrumenter() {}
        
    virtual TResult Initialize(const char* options,
                               bool enableStackMapCalc) = 0;
    
    virtual TResult Instrument(TMemoryAllocatorFunc memAllocFunc,
							   const char* className,
                   	           const char* inClass, S32 inClassLength, 
                               char** outClass, S32* outClassLength) = 0;
                            
	virtual void OnVMInit() = 0;

	virtual void OnDataCollectionEnabled() = 0;
};

class CBCIInstrumenter : public IInstrumenter     
{
    bool m_initialized;
    bool m_stackMapCalcEnabled;
	bool m_JVMInitDone;
        
public:
    
    CBCIInstrumenter();
    virtual ~CBCIInstrumenter();
    
    virtual TResult Initialize(const char* options,
                               bool enableStackMapCalc);
    
    // Instrument returns MRTE_RESULT_TRUE if instrumented,
    // MRTE_RESULT_FALSE if not instrumented, an error code
    // otherwise.
    virtual TResult Instrument(TMemoryAllocatorFunc memAllocFunc,
							   const char* className,
                               const char* inClass, S32 inClassLength, 
                               char** outClass, S32* outClassLength); 
                            
	virtual void OnVMInit();

	virtual void OnDataCollectionEnabled();

private:
	void loadDelayedClass();
};


} /*namespace Martini*/  } /*namespace ProbekitAgent*/

#endif // PROBEKIT_INSTRUMENTER_H
