/************************************************************************
 * Copyright (c) 2007, 2009 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#include "ProbekitAgent.h"
#include "InstrumenterFactory.h"
#include "Instrumenter.h"

// Martini
#include "LibraryLoader.h"
#include "log.h"

using namespace Martini;
using namespace Martini::MPI;
using namespace Martini::OSA;
using namespace Martini::JPIAgent;
using namespace Martini::ProbekitAgent;

using namespace std;

static Martini::ProbekitAgent::CProbekitAgent probekitAgent;

/////////////////////////////////////////////////////////////////

Martini::OSA::IThreadSync* lockObject = Martini::OSA::CreateThreadSync();

/////////////////////////////////////////////////////////////////


/*
 *    MPICL_Instantiate - The profiler initialization method. 
 *    The profiler initializes itself and registers for MPI events 
 */
extern "C" API_EXPORT TResult 
MPICL_Instantiate(IMpi *pMpiApi, TId clientId, const char *szOptions)
{
	LOG_TRACE(PROFILER_NAME " MPICL_Instantiate");
       
    LOG_ASSERT(pMpiApi != 0);
    LOG_ASSERT(clientId != 0);
        
    TResult retVal = probekitAgent.Init(pMpiApi, clientId, szOptions);
    if (MRTE_FAILED(retVal))
    {
        return MRTE_ERROR_FAIL;
    }

    bool enableStackMapCalc = probekitAgent.getEC()->isCalcStackMap();	
    if (enableStackMapCalc) 
    {
        pMpiApi->Configure(CF_JAVA_ENABLE_STACKMAP_CALC);
    }


    IInstrumenter* instrumenter =
    	CInstrumenterFactory::getInstrumenter();
	if( instrumenter ) {
    	retVal = instrumenter->Initialize(szOptions, enableStackMapCalc);
	} else {
		            
        LOG_ERROR( "Can't create instrumenter" );
        retVal = MRTE_ERROR_FAIL;
           
    } 
    LOG_TRACE(PROFILER_NAME " MPICL_Instantiate done");
    return retVal;
}

//=======================================================================================

CProbekitAgent* CProbekitAgent::getInstance()
{
	return &probekitAgent;
}

CProbekitAgent::CProbekitAgent()
  : ec_env( NULL )
{
}

CProbekitAgent::~CProbekitAgent()
{
}

/*
 * InitEvents - initialize object event - register events
 */

TResult CProbekitAgent::Init(MPI::IMpi *pMpiApi, MPI::TId clientId, 
                             const char *szOptions)
{
	TResult retVal;    

    m_pMpiApi   =   pMpiApi;
    m_clientId  =   clientId;

	retVal = InitEC();
    if (MRTE_FAILED(retVal))
    {
    	LOG_ERROR( PROFILER_NAME " error initializing EC");
        return retVal;
    }
    
    retVal = InitEvents();
    if (MRTE_FAILED(retVal))
    {
    	LOG_ERROR( PROFILER_NAME " error registering events");
        return retVal;
    }
    
    retVal = BindJpiFunctions();
    if (MRTE_FAILED(retVal))
    {
    	LOG_ERROR( PROFILER_NAME " failed to bind JPI exported functions");
    }    

    return retVal;                               
}

/*
 * InitEvents - initialize object event - register events
 */
TResult CProbekitAgent::InitEvents()
{
    TResult retVal;    

	// EC stop event; Martini RT will sleep
	// in this event initialization
	retVal = m_ECAttachHandler.Init(m_pMpiApi, m_clientId);
    if (MRTE_FAILED(retVal))
    {
        return retVal;
    }
	if(getEC()->isEnabled()) {
		retVal = m_ECCustomHandler.Init(m_pMpiApi, m_clientId);
		if (MRTE_FAILED(retVal))
		{
			return retVal;
		}
	}
	

	retVal = m_ECDetachHandler.Init(m_pMpiApi, m_clientId);
    if (MRTE_FAILED(retVal))
    {
        return retVal;
    }
	
	retVal = m_ECStartHandler.Init(m_pMpiApi, m_clientId);
    if (MRTE_FAILED(retVal))
    {
        return retVal;
    }

	retVal = m_ECStopHandler.Init(m_pMpiApi, m_clientId);
    if (MRTE_FAILED(retVal))
    {
        return retVal;
    }
    
    retVal = m_ClassFileLoadHookHandler.Init(m_pMpiApi, m_clientId);
    if (MRTE_FAILED(retVal))
    {
        return retVal;
    }

    retVal = m_VMInitHandler.Init(m_pMpiApi, m_clientId);
    if (MRTE_FAILED(retVal))
    {
        return retVal;
    }
                       
    return MRTE_RESULT_OK;
}

/*
 * BindJpiFunctions - bind required exported JPI functions
 */
TResult CProbekitAgent::BindJpiFunctions()
{
    ILibraryLoader *pJpiLoader = LoadBistroLibrary("JPI");
    if (!pJpiLoader)
    {
        return MRTE_ERROR_FAIL;
    }

    CGlobals::Instance()->pfnJPI_AttachCurrentThread = 
        (TJpiAttachCurrentThread)pJpiLoader->GetEntry("JPI_AttachCurrentThread");
    if (!CGlobals::Instance()->pfnJPI_AttachCurrentThread)
    {
        return MRTE_ERROR_FAIL;
    }

    CGlobals::Instance()->pfnJPI_DetachCurrentThread = 
        (TJpiDetachCurrentThread)pJpiLoader->GetEntry("JPI_DetachCurrentThread");
    if (!CGlobals::Instance()->pfnJPI_DetachCurrentThread)
    {
        return MRTE_ERROR_FAIL;
    }
    
    pJpiLoader->Destroy();

    return MRTE_RESULT_OK;
}

TResult CProbekitAgent::InitEC()
{
  	LOG_TRACE( PROFILER_NAME " InitEC");

    Martini::OSA::ILibraryLoader* libraryLoader;
    	
    // Modified for bug 241984 and bug 226572
	//libraryLoader = CreateLibraryLoader("JPIAgent", 0);
    libraryLoader = LoadBistroLibrary("JPIAgent"); 
    // Modified for bug 241984 and bug 226572

    if (libraryLoader == 0) {
        return MRTE_ERROR_OSA_FAILURE;
    }
    GetEC_Env_t ecpEnv = (GetEC_Env_t)(libraryLoader->GetEntry("GetEC_Env"));
    if (ecpEnv == 0) {
        return MRTE_ERROR_OSA_FAILURE;
    }
    
    (*ecpEnv)("org.eclipse.tptp.analysisType.jvmti.probe", &ec_env); // fixed for 190684

	libraryLoader->Destroy();
    
    return MRTE_RESULT_OK;
}
