/************************************************************************
 * Copyright (c) 2007, 2008 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#ifndef _PROBEKIT_AGENT_H
#define _PROBEKIT_AGENT_H

#include "MpiAPI.h"
#include "OSA.h"
#include "MRTEResults.h"

#include "VMInitEvent.h"
#include "ECAttachEvent.h"
#include "ECDetachEvent.h"
#include "ECStartEvent.h"
#include "ECStopEvent.h"
#include "ECCustomEvent.h"
#include "ClassFileLoadHookEvent.h"
#include "Globals.h"
#include "EC_Env.h"

namespace Martini { namespace ProbekitAgent {

    class CProbekitAgent //: public BaseProf::CBaseProfiler
    {            
    public:
        CProbekitAgent();
        virtual ~CProbekitAgent();
        
        static CProbekitAgent* getInstance();
        
        TResult Init(MPI::IMpi *pMpiApi, MPI::TId clientId, const char *szOptions);                
        
        JPIAgent::EC_Env* getEC() 
        { return ec_env; }

	private:

		// Initializes internal data and registers for VM shutdown event
        TResult InitEvents();
        
        // Bind required JPI exported functions
        TResult BindJpiFunctions();
        
        // Initialize EC environment	        
		TResult InitEC();
	        
    private:
        
        // VM init event object
        CVMInitEvent m_VMInitHandler;

		// the agent doesn't use EC events but they seem
		// necessary to make Martini RT sleep in controlled mode.

		CECAttachEvent m_ECAttachHandler;
		CECDetachEvent m_ECDetachHandler;
		CECStartEvent m_ECStartHandler;
		CECStopEvent m_ECStopHandler;
		CECCustomEvent m_ECCustomHandler;

        // Class File Load Hook event object
        CClassFileLoadHookEvent m_ClassFileLoadHookHandler;

        // EC environment
        JPIAgent::EC_Env* ec_env;
        
        // Pointer to the MPI implementation
        MPI::IMpi* m_pMpiApi;

        // Client id for MPI requests
        MPI::TId m_clientId;
    };

} /*namespace Martini*/  } /*namespace ProbekitAgent*/

#endif // _PROBEKIT_AGENT_H
