/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#ifndef _PROBEKIT_UTIL_H
#define _PROBEKIT_UTIL_H

#define PROFILER_NAME "PROBEKIT"

namespace Martini { namespace ProbekitAgent { namespace Util {
		
	// Dump buffer to location specified by dir;
	// Do nothing if the location is null.
	void DumpBuffer( const char* dir, const char* fileName, 
				     const char* buffer, int len );

	// Read file into a buffer; caller must free result
	void ReadFile( const char* fname, char*& result, int& resultLen );

	// parse options, look for specified name
	char* GetCmdlineOption( const char* options, const char* name );	
	
	// return 0 if success
	int DecodeBuffer( const char* inBuffer, int inLen, char* outBuffer);
	int DecodeBufferLength( const char* inBuffer, int inLen );
	
	// malloc a new string, strcpy len bytes, add zero
	char* StrNDup( const char* src, int len );
			
} /*namespace Martini*/  } /*namespace ProbekitAgent*/ } /*namespace Util*/

#endif // _PROBEKIT_UTIL_H
