/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#include "VMInitEvent.h"
#include "Globals.h"
#include "InstrumenterFactory.h"
#include "Instrumenter.h"
#include <log.h>

using namespace Martini::ProbekitAgent;
using namespace Martini::MPI;

CVMInitEvent::CVMInitEvent()
{}

CVMInitEvent::~CVMInitEvent()
{}

/*
 * Init	- initializes internal data and registers for VM init event	
 */
TResult CVMInitEvent::Init(IMpi *pMpiApi, TId clientId)
{
	m_pMpiApi	=	pMpiApi;
	m_clientId	=	clientId;

	// register for VM init event
	TResult res = m_pMpiApi->RegisterEvent(m_clientId, *this);
	return res;
}

/*
 * HandleEvent - callback function for VM init event	
 */
void CVMInitEvent::HandleEvent(SVmInitEventData &data)
{
    LOG_TRACE( PROFILER_NAME " VM Init" );
    
    CInstrumenterFactory::getInstrumenter()->OnVMInit();    
    CGlobals::Instance()->m_VMInitSeen = true;
}
