/************************************************************************
 * Copyright (c) 2007 OC Systems Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vsevolod Sandomirskiy, OC Systems - Probekit support
 *
 * $Id$ 
 ************************************************************************/
 
#ifndef PROBEKIT_VM_INIT_H
#define PROBEKIT_VM_INIT_H

#include "MpiAPI.h"

namespace Martini { namespace ProbekitAgent {

	// CVMInitEvent - represents a VM init event 
	class CVMInitEvent : public MPI::IVmInitEventObserver
	{
	public:
		CVMInitEvent();
		~CVMInitEvent();

        // Initialization - Register to event
		TResult Init(MPI::IMpi *pMpiApi, MPI::TId clientId);
        
        // Event handler
        void HandleEvent(MPI::SVmInitEventData &data);

	private:
		// Pointer to the MPI implementation
        MPI::IMpi *m_pMpiApi;

        // Client id for MPI requests
	    MPI::TId m_clientId;
	};

} /*namespace Martini*/  } /*namespace ProbekitAgent*/

#endif	// PROBEKIT_VM_INIT_H

