/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ContendedMonitorEnteredEvent.h,v 1.2 2007/03/23 14:04:39 vrybalov Exp $ 
 ************************************************************************/

#ifndef _CONTENDED_MONITOR_ENTERED_EVENT_H_
#define _CONTENDED_MONITOR_ENTERED_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace ThreadProf {

    // CContendedMonitorEnteredEvent - represents a contended monitor enter event 
    class CContendedMonitorEnteredEvent : public MPI::IContendedMonitorEnteredEventObserver
    {
    public:
        // Constructor
        CContendedMonitorEnteredEvent();
        // Destructor
        ~CContendedMonitorEnteredEvent();
        // Initializes internal data and registers contended monitor enter event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SContendedMonitorEnteredEventData &data);

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace ThreadProf*/

#endif // _CONTENDED_MONITOR_ENTERED_EVENT_H_
