/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: MonitorWaitEvent.cpp,v 1.12 2008/06/16 21:02:24 jkubasta Exp $ 
 ************************************************************************/

#include "MonitorWaitEvent.h"

using namespace Martini::ThreadProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;
using namespace Martini::JPIAgent;

CMonitorWaitEvent::CMonitorWaitEvent(){}
CMonitorWaitEvent::~CMonitorWaitEvent(){}

/*
 * Init - initializes internal data and registers for monitor wait event    
 */
TResult 
CMonitorWaitEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for monitor wait event    
 */
void 
CMonitorWaitEvent::HandleEvent(SMonitorWaitEventData &data)
{
    LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_ID) != 0);
    LOG_ASSERT((data.validData & DR_MONITOR_TIMEOUT) != 0);
    m_pProfEnv->AddTimeOut(m_pProfEnv->ec_env->GetTime(), data.threadId);
    m_pProfEnv->CheckObjectId(data.objectId, data.threadId);
    if (!m_pProfEnv->m_profilerIsActive) {
        m_pProfEnv->StoreThreadEvent(data.threadId, MONITOR_WAIT_EVENT, &data, 0);
        return;
    }
    if (m_pProfEnv->ec_env->isStackInfoNormal()) {
        SStackTrace_ stackTrace;
        m_pProfEnv->GetStackTrace(data.threadId, &stackTrace);
        m_pProfEnv->ec_env->PrintMonitorWaitElement(&data, &stackTrace);
        m_pProfEnv->FreeStackTrace(&stackTrace);
    } else {
        m_pProfEnv->ec_env->PrintMonitorWaitElement(&data, 0);
    }
}
