/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: MonitorWaitEvent.h,v 1.2 2007/03/23 14:04:40 vrybalov Exp $ 
 ************************************************************************/

#ifndef _MONITOR_WAIT_EVENT_H_
#define _MONITOR_WAIT_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace ThreadProf {

    // CMonitorWaitEvent - represents a monitor wait event 
    class CMonitorWaitEvent : public MPI::IMonitorWaitEventObserver
    {
    public:
        // Constructor
        CMonitorWaitEvent();
        // Destructor
        ~CMonitorWaitEvent();
        // Initializes internal data and registers monitor wait event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SMonitorWaitEventData &data);

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace ThreadProf*/

#endif // _MONITOR_WAIT_EVENT_H_
