/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: MonitorWaitedEvent.cpp,v 1.11 2008/05/13 05:28:29 aalexeev Exp $ 
 ************************************************************************/

#include "MonitorWaitedEvent.h"

using namespace Martini::ThreadProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;
using namespace Martini::JPIAgent;

CMonitorWaitedEvent::CMonitorWaitedEvent(){}
CMonitorWaitedEvent::~CMonitorWaitedEvent(){}

/*
 * Init - initializes internal data and registers for monitor waited event    
 */
TResult 
CMonitorWaitedEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for monitor wait event    
 */
void 
CMonitorWaitedEvent::HandleEvent(SMonitorWaitedEventData &data)
{
    LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_ID) != 0);
    LOG_ASSERT((data.validData & DR_MONITOR_TIMED_OUT) != 0);

    m_pProfEnv->CheckObjectId(data.objectId, data.threadId);
    if (!m_pProfEnv->m_profilerIsActive) {
        m_pProfEnv->StoreThreadEvent(data.threadId, MONITOR_WAITED_EVENT, &data, m_pProfEnv->ec_env->GetTime() - m_pProfEnv->GetTimeOut(data.threadId));
        return;
    }
    if (m_pProfEnv->ec_env->isStackInfoNormal()) {
        SStackTrace_ stackTrace;
        m_pProfEnv->GetStackTrace(data.threadId, &stackTrace);
        m_pProfEnv->ec_env->PrintMonitorWaitedElement(&data, m_pProfEnv->ec_env->GetTime() - m_pProfEnv->GetTimeOut(data.threadId), &stackTrace);
        m_pProfEnv->FreeStackTrace(&stackTrace);
    } else {
        m_pProfEnv->ec_env->PrintMonitorWaitedElement(&data, m_pProfEnv->ec_env->GetTime() - m_pProfEnv->GetTimeOut(data.threadId), 0);
    }
}
