/************************************************************************
 * Copyright (c) 2006 - 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Alexander Alexeev, Intel - Initial API and implementation
 *
 * $Id: ThreadInteractionEvent.cpp,v 1.4 2009/06/07 16:54:08 kchan Exp $ 
 ************************************************************************/

#include "ThreadInteractionEvent.h"

using namespace Martini::ThreadProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;
using namespace Martini::JPIAgent;

CThreadInteractionEvent::CThreadInteractionEvent(){}
CThreadInteractionEvent::~CThreadInteractionEvent(){}

/*
 * Init - initializes internal data and registers for call interrupt event    
 */
TResult 
CThreadInteractionEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for call interrupt event    
 */
void 
CThreadInteractionEvent::HandleEvent(SThreadInteractionEventData &data)
{
    LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_ID) != 0);
    LOG_ASSERT((data.validData & DR_THREAD_INTERACTION_TYPE) != 0);

    m_pProfEnv->AddTimeOut(m_pProfEnv->ec_env->GetTime(), data.threadId);
    m_pProfEnv->CheckObjectId(data.objectId, data.threadId);
    if (!m_pProfEnv->m_profilerIsActive) {
        m_pProfEnv->StoreThreadEvent(data.threadId, THREAD_INTERACTION, &data, 0);
        return;
    }

    if (m_pProfEnv->ec_env->isStackInfoNormal()) {
        SStackTrace_ stackTrace = {0};
        m_pProfEnv->GetStackTrace(data.threadId, &stackTrace);
        m_pProfEnv->ec_env->printThreadInteractionElements(&data, &stackTrace);
        m_pProfEnv->FreeStackTrace(&stackTrace);
    } else {
        m_pProfEnv->ec_env->printThreadInteractionElements(&data, 0);
    }
}
