/************************************************************************
 * Copyright (c) 2006 - 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Alexander Alexeev, Intel - Initial API and implementation
 *
 * $Id: ThreadInteractionEvent.h,v 1.1 2008/02/29 15:35:16 aalexeev Exp $ 
 ************************************************************************/

#ifndef _THREAD_INTERACTION_EVENT_H_
#define _THREAD_INTERACTION_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
#include "log.h"

namespace Martini { namespace ThreadProf {

    // CCallInterruptEvent - represents a call for interrupt method event 
    class CThreadInteractionEvent : public MPI::IThreadInteractionEventObserver
    {
    public:
        // Constructor
        CThreadInteractionEvent();
        // Destructor
        ~CThreadInteractionEvent();
        // Initializes internal data and registers monitor wait event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SThreadInteractionEventData &data);

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace ThreadProf*/

#endif // _THREAD_INTERACTION_EVENT_H_
