/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ThreadProfiler.h,v 1.8 2008/02/29 19:16:31 jkubasta Exp $ 
 ************************************************************************/

#ifndef _THREAD_PROFILER_H_
#define _THREAD_PROFILER_H_

#include "BaseProfiler.h"
#include "ThreadStartEvent.h"
#include "ThreadEndEvent.h"
#include "MonitorWaitEvent.h"
#include "MonitorWaitedEvent.h"
#include "ContendedMonitorEnterEvent.h"
#include "ContendedMonitorEnteredEvent.h"
#include "NewMethodEvent.h"
#include "CustomCommandEvent.h"
#include "ThreadInteractionEvent.h"


namespace Martini { namespace ThreadProf {


    class CThreadInteractionFilter : public MPI::IThreadInteractionFilter
    {
    public:
        CThreadInteractionFilter(BaseProf::CProfEnv* profEnv);
        bool ShouldNotify(MPI::SThreadInteractionFilterData &data);
    private:
        // profilrt env object
        BaseProf::CProfEnv* m_pProfEnv;
    };


    class CThreadProfiler : public BaseProf::CBaseProfiler
    {
    public:
        // Constructor
        CThreadProfiler();
        // Destructor
        ~CThreadProfiler();

    protected:
        virtual TResult InitProfilerSpecificEvents();
        virtual TResult InitFilter();
        virtual TResult ParceOptions(const char *szOptions);

    private:
        // Thread start event object
        CThreadStartEvent   m_threadStartHandler;
        // Thread end event object
        CThreadEndEvent     m_threadEndHandler;
        // Monitor wait event object
        CMonitorWaitEvent   m_monitorWaitHandler;
        // Monitor waited event object
        CMonitorWaitedEvent m_monitorWaitedHandler;
        // Contended monitor enter event object
        CContendedMonitorEnterEvent   m_contendedMonitorEnterHandler;
        // Contended monitor entered event object
        CContendedMonitorEnteredEvent m_contendedMonitorEnteredHandler;
        // New method event object
        CNewMethodEvent     m_newMethodHandler;
        // CustomCommand event object
        CCustomCommandEvent m_customCommandHandler;
        // call CA method event object
        CThreadInteractionEvent m_threadInteractionHandler;
    };

} /*namespace Martini*/  } /*namespace ThreadProf*/

#endif // _THREAD_PROFILER_H_
