/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ThreadStartEvent.cpp,v 1.10 2008/06/16 21:02:24 jkubasta Exp $ 
 ************************************************************************/

#include "ThreadStartEvent.h"

using namespace Martini::ThreadProf;
using namespace Martini::BaseProf;
using namespace Martini::MPI;

CThreadStartEvent::CThreadStartEvent(){}
CThreadStartEvent::~CThreadStartEvent(){}

/*
 * Init - initializes internal data and registers for thread start event    
 */
TResult 
CThreadStartEvent::Init(CProfEnv* profEnv)
{
    m_pProfEnv = profEnv;
    TResult retVal = profEnv->m_pMpiApi->RegisterEvent(profEnv->m_clientId, *this);
    return retVal;
}

/*
 * HandleEvent - callback function for thread start event    
 */
void 
CThreadStartEvent::HandleEvent(SThreadEventData &data)
{
    LOG_ASSERT((data.validData & DR_THREAD_ID) != 0);
    LOG_ASSERT((data.validData & DR_OBJECT_ID) != 0);
    // request thread information
    SThreadInfo threadInfo;
    TResult iRes = m_pProfEnv->GetThreadInfo(m_pProfEnv->m_clientId, data.threadId, 
            DR_THREAD_INFO, &threadInfo);
    if (iRes != MRTE_RESULT_OK) {
        LOG_TRACE("Thread start event (GetThreadInfo wrong phase)");
        return;
    }

    m_pProfEnv->CheckObjectId(data.objectId, data.threadId);
    if (!m_pProfEnv->m_profilerIsActive) {
        m_pProfEnv->StoreThreadEvent(data.threadId, THREAD_START_EVENT, &threadInfo, 0, data.objectId);
        return;
    }

    m_pProfEnv->ec_env->PrintThreadStartElement(data.threadId, data.objectId, &threadInfo);
}
