/************************************************************************
 * Copyright (c) 2006 - 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ThreadStartEvent.h,v 1.3 2007/03/23 14:04:39 vrybalov Exp $ 
 ************************************************************************/

#ifndef _THREAD_START_EVENT_H_
#define _THREAD_START_EVENT_H_

#include "MpiAPI.h"
#include "ProfEnv.h"
//#include "Tickets.h"
#include "log.h"

namespace Martini { namespace ThreadProf {

    // CThreadStartEvent - represents a thread start event 
	class CThreadStartEvent : public MPI::IThreadStartEventObserver
    {
    public:
        // Constructor
        CThreadStartEvent();
        // Destructor
        ~CThreadStartEvent();
        // Initializes internal data and registers thread start event
        TResult Init(BaseProf::CProfEnv* profEnv);
        // Inherited methods
        void HandleEvent(MPI::SThreadEventData &data);

        MPI::BitSet EventDataTypes() {
            return MPI::DR_THREAD_ID | MPI::DR_OBJECT_ID;
        }

    private:
        // profiler environment
        BaseProf::CProfEnv* m_pProfEnv;
    };

} /*namespace Martini*/ } /*namespace ThreadProf*/

#endif // _THREAD_START_EVENT_H_
