ifndef ROOTDIR
	echo "ROOTDIR must be defined"
	exit 1
endif

##########################################################
#  Define platform variables (IA32/IPF/EM64T)
##########################################################
ifndef IA32
    ifeq ($(shell uname -m), i686)
        IA32=1
	ifeq ($(SUFFIX),)
        	SUFFIX=32
	endif
	LINUX_GCC_COMPILER=1
	LINUX=1
    endif
endif

ifndef IPF
    ifeq ($(shell uname -m), ia64)
        IPF=1
	ifeq ($(SUFFIX),)
        	SUFFIX=64
	endif
	LINUX_GCC_COMPILER=1
	LINUX=1
    endif
endif

ifndef EM64T
    ifeq ($(shell uname -m), x86_64)
        ifdef FORCE32
            IA32=1
            ifeq ($(SUFFIX),)
                SUFFIX=32
            endif
        else
            EM64T=1
	        ifeq ($(SUFFIX),)
        	    SUFFIX=32e
	        endif
	    endif
	LINUX_GCC_COMPILER=1
	LINUX=1
    endif
endif

ifndef AIX 
    ifeq ($(shell uname), AIX)
			AIX=1
			ifeq ($(SUFFIX),)
				SUFFIX=32
			endif
		AIX_COMPILER=1
    endif
endif

ifndef SOLARIS
	ifeq ($(shell uname -m), sun4u)
		SOLARIS=1
		ifeq ($(SUFFIX),)
			SUFFIX=32
		endif
	SOLARIS_COMPILER=1
	endif
endif

ifndef SOLARISX86
	ifeq ($(shell uname -m), i86pc)
		SOLARISX86=1
		ifeq ($(SUFFIX),)
			SUFFIX=32
		endif
		SOLARISX86_COMPILER=1
	endif
endif

#Added FORCE31 option to force 31 bit compile on 64-bit Linux 390 systems  - SL
ifndef S390X
    ifeq ($(shell uname -m), s390x)
    	ifdef FORCE31
         	S390=1
        	ifeq ($(SUFFIX),)
        		SUFFIX=32
		endif   	
    	else
        	S390X=1
		ifeq ($(SUFFIX),)
        		SUFFIX=64
		endif
	endif
	LINUX_GCC_COMPILER=1
	LINUX=1
    endif
endif

# MVS
ifeq ($(shell uname -s), OS/390)
	MVS=1
	MVS_COMPILER=1
	ifdef SIXTYFOURBIT
		SIXTYFOURBIT=LP64,
		AMODEBIT=64
	else
		AMODEBIT=31
	endif
endif

ifndef S390
	ifeq ($(shell uname -m), s390)
		S390=1
		ifeq ($(SUFFIX),)
			SUFFIX=32
		endif
		LINUX_GCC_COMPILER=1
		LINUX=1
	endif
endif


##########################################################
#  Set compiler type and flags
##########################################################

ifdef MVS_COMPILER
	GCC_COMPILER = xlc
	GPP_COMPILER = xlc++

	BINUTILS_PATH = /usr/bin 

	C_COMPILER_TYPE = xlc
	CXX_COMPILER_TYPE = xlc++
	USE_GCC_COMPILER=yes
	EXTRA_C_FLAGS =
	EXTRA_CXX_FLAGS =
	DIR_EXTENTION= 
endif

ifdef AIX_COMPILER
	GCC_COMPILER = xlc_r
	GPP_COMPILER = xlc++_r

	BINUTILS_PATH = /usr/bin 

	C_COMPILER_TYPE = xlc_r
	CXX_COMPILER_TYPE = xlc++_r
	USE_GCC_COMPILER=yes
	EXTRA_C_FLAGS =
	EXTRA_CXX_FLAGS =

endif

ifdef SOLARISX86_COMPILER
		GCC_COMPILER = cc
		GPP_COMPILER = CC
		
		BINUTILS_PATH = /opt/SUNWspro/bin/
		
		C_COMPILER_TYPE = cc
		CXX_COMPILER_TYPE = CC
		USE_GCC_COMPILER=no
		EXTRA_C_FLAGS =
		EXTRA_CXX_FLAGS =
		DIR_EXTENTION=	
endif

ifdef SOLARIS_COMPILER
	GCC_COMPILER = cc
	GPP_COMPILER = CC
	
	BINUTILS_PATH = /opt/SUNWspro/bin/
	
	C_COMPILER_TYPE = cc
	CXX_COMPILER_TYPE = CC
	USE_GCC_COMPILER=no
	EXTRA_C_FLAGS =
	EXTRA_CXX_FLAGS =
	DIR_EXTENTION=
endif

ifdef LINUX_GCC_COMPILER
	GCC_COMPILER = gcc
	GPP_COMPILER = g++
	
	BINUTILS_PATH = /usr/bin 
	
	C_COMPILER_TYPE = gcc
	CXX_COMPILER_TYPE = g++
	USE_GCC_COMPILER=yes
	EXTRA_C_FLAGS =
	EXTRA_CXX_FLAGS =
	DIR_EXTENTION= 
	
endif

ifdef NO_GCC_FLAGS
    EXTRA_C_FLAGS =
    EXTRA_CXX_FLAGS =
endif

ifdef LINK
    EXTRA_LINK_DIR = -l$(LINK)
else
    EXTRA_LINK_DIR =
endif 

ifndef EXTRA_INCLUDES
	EXTRA_INCLUDES = 
endif

ifdef AIX
	ifdef RELEASE
		COMPILER_FLAGS = -O3 -qpic=large 
	else
		ifdef RELEASE_WD 
			# Release with debug info
			COMPILER_FLAGS = -g -O3 -DDEBUG -qpic=large 
		else
			# Debug
			COMPILER_FLAGS = -g -DDEBUG -qpic=large 
		endif
	endif

	ifdef SIXTYFOURBIT
		COMPILER_FLAGS += -q64
	else 
		COMPILER_FLAGS += -q32
	endif

	COMPILER_FLAGS += -D_AIX
endif

ifdef MVS
	# MVS
    ifdef RELEASE
		COMPILER_FLAGS = -O2 -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -D_UNIX03_SOURCE -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED,LONGLONG\),LONGNAME,DLL,XPLINK,EXPORTALL,TARGET\(zOSV1R9\),ASCII
	else
		ifdef RELEASE_WD 
			# Release with debug info
			COMPILER_FLAGS = -O2 -DDEBUG -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -D_UNIX03_SOURCE -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED,LONGLONG\),LONGNAME,DLL,XPLINK,EXPORTALL,TARGET\(zOSV1R9\),ASCII
		else
			# Debug
			COMPILER_FLAGS = -DDEBUG -D_OS390 -D_UNIX03_THREADS -DMVS=1 -D_XOPEN_SOURCE_EXTENDED=1 -D_POSIX_SOURCE -D_UNIX03_SOURCE -W c,$(SIXTYFOURBIT)CSECT,NOLOCALE,LANGLVL\(EXTENDED,LONGLONG\),LONGNAME,DLL,XPLINK,EXPORTALL,TARGET\(zOSV1R9\),ASCII
		endif
	endif

endif
ifdef IA32
	ifdef RELEASE
		COMPILER_FLAGS = -O3 -m32
	else
		ifdef RELEASE_WD 
			# Release with debug info
			COMPILER_FLAGS = -g3 -O3 -m32 -DDEBUG
		else
			# Debug
			COMPILER_FLAGS = -g3 -m32 -DDEBUG
		endif
	endif
endif

ifdef SOLARIS
		
	ifdef SIXTYFOURBIT
		LIBLOCATION = -L/usr/lib/sparcv9 -L/usr/local/lib/sparcv9/lib -R /usr/lib/64
	else
		LIBLOCATION = -L/usr/lib -L/usr/local/lib -R /usr/local/lib
	endif
		
	ifdef RELEASE
		COMPILER_FLAGS= -xCC -KPIC -D_SOLARIS -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 $(LIBLOCATION)
	else
		ifdef RELEASE_WD
			COMPILER_FLAGS= -xCC -KPIC -g -D_SOLARIS -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 $(LIBLOCATION)
		else
			COMPILER_FLAGS= -xCC -KPIC -g -D_SOLARIS -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 $(LIBLOCATION)
		endif
	endif

	ifdef SIXTYFOURBIT
		COMPILER_FLAGS += -xtarget=ultra -xarch=v9
	endif

endif

ifdef SOLARISX86

	ifdef SIXTYFOURBIT
		LIBLOCATION = -L/usr/lib/amd64
	else
		LIBLOCATION = -L/usr/lib
	endif
	
	ifdef RELEASE
		COMPILER_FLAGS= -xCC -KPIC -D_SOLARISX86 -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 $(LIBLOCATION)
	else
		ifdef RELEASE_WD
			COMPILER_FLAGS= -xCC -KPIC -g -D_SOLARISX86 -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 $(LIBLOCATION)
		else
			COMPILER_FLAGS= -xCC -KPIC -g -D_SOLARISX86 -DENW -DSQLUNIX -DSOLARIS -D_REENTRANT -D__suncc42 $(LIBLOCATION)
		endif
	endif

	ifdef SIXTYFOURBIT
	
		COMPILER_FLAGS += -xarch=amd64
	endif
endif


ifdef S390X
  ifdef RELEASE
		COMPILER_FLAGS = -O2 -fPIC -m64 -I$(UUID_INCLUDE_DIR)
	else
		ifdef RELEASE_WD 
			# Release with debug info
			COMPILER_FLAGS = -g3 -O2 -DDEBUG -fPIC -m64 -Wall -I$(UUID_INCLUDE_DIR)
		else
			# Debug
			COMPILER_FLAGS = -g3 -DDEBUG -fPIC -m64 -Wall -I$(UUID_INCLUDE_DIR)
		endif
	endif
endif

ifdef S390 
 	ifdef RELEASE
		COMPILER_FLAGS = -O2 -fPIC -m31 -I$(UUID_INCLUDE_DIR)
	else
		ifdef RELEASE_WD 
			# Release with debug info
			COMPILER_FLAGS = -g3 -O2 -DDEBUG -fPIC -m31 -Wall -I$(UUID_INCLUDE_DIR)
		else
			# Debug
			COMPILER_FLAGS = -g3 -DDEBUG -fPIC -m31 -Wall -I$(UUID_INCLUDE_DIR)
		endif
	endif
endif


ifdef IPF
	#IPF
 	ifdef RELEASE
		COMPILER_FLAGS = -O2 -fPIC
	else 
		ifdef RELEASE_WD
			# Release with debug info
			COMPILER_FLAGS = -g3 -O2 -DDEBUG -fPIC
		else
			# Debug
			COMPILER_FLAGS = -g3 -DDEBUG -fPIC
		endif
	endif
endif

ifdef EM64T
	# EM64T
 	ifdef RELEASE
		COMPILER_FLAGS = -O2 -fPIC
	else 
		ifdef RELEASE_WD
			# Release with debug info
			COMPILER_FLAGS = -g3 -O2 -DDEBUG -fPIC
		else
			# Debug
			COMPILER_FLAGS = -g3 -DDEBUG -fPIC
		endif
	endif
endif

# Inititialize the DEFINES variable
ifndef DEFINES
	DEFINES = 
endif
	
ifndef RELEASE
	BUILD_LINKING_FLAGS += -g 
else
	ifdef LINUX_GCC_COMPILER
		BUILD_LINKING_FLAGS += -W1 -O2
	endif
endif

GPP= $(GPP_COMPILER) $(EXTRA_CXX_FLAGS) $(COMPILER_FLAGS)
GCC= $(GCC_COMPILER) $(EXTRA_C_FLAGS) $(COMPILER_FLAGS)

CPP_COMPILE = $(GPP) -c $< $(INCLUDES) $(EXTRA_INCLUDES) -o $@  $(DEFINES)
C_COMPILE = $(GCC) -c $< $(INCLUDES) $(EXTRA_INCLUDES) -o $@  $(DEFINES)

CPP_LINKER = $(GPP_COMPILER) $(EXTRA_CXX_FLAGS) $(BUILD_LINKING_FLAGS)
C_LINKER = $(GCC_COMPILER) $(EXTRA_C_FLAGS) $(BUILD_LINKING_FLAGS)

##########################################################
#  Set directories
##########################################################

ifdef EM64T
    RELEASE_DIR_NAME=EM64TRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=EM64TReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=EM64TDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release/EM64T$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release_debug_info/EM64T$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/linux/debug/EM64T$(DIR_EXTENTION)
endif
ifdef IPF
    RELEASE_DIR_NAME=IPFRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=IPFReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=IPFDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release/IPF$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release_debug_info/IPF$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/linux/debug/IPF$(DIR_EXTENTION)
endif
ifdef IA32
    RELEASE_DIR_NAME=IA32Release$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=IA32ReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=IA32Debug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release/IA-32$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release_debug_info/IA-32$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/linux/debug/IA-32$(DIR_EXTENTION)
endif
ifdef AIX
    RELEASE_DIR_NAME=AIXRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=AIXReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=AIXDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/aix/release/AIX$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/aix/release_debug_info/AIX$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/aix/debug/AIX$(DIR_EXTENTION)

endif
ifdef SOLARIS
    RELEASE_DIR_NAME=SolarisRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=SolarisReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=SolarisDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/solaris/release/sparc$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/solaris/release_debug_info/sparc$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/solaris/debug/sparc$(DIR_EXTENTION)
endif
ifdef SOLARISX86
    RELEASE_DIR_NAME=SolarisRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=SolarisReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=SolarisDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/solaris/release/x86$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/solaris/release_debug_info/x86$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/solaris/debug/x86$(DIR_EXTENTION)
endif
ifdef MVS
    RELEASE_DIR_NAME=MVSRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=MVSReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=MVSDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release/MVS$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release_debug_info/MVS$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/linux/debug/MVS$(DIR_EXTENTION)
endif
ifdef S390
    RELEASE_DIR_NAME=S390Release$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=S390ReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=S390Debug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release/S390$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release_debug_info/S390$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/linux/debug/S390$(DIR_EXTENTION)
endif
ifdef S390X
    RELEASE_DIR_NAME=S390XRelease$(DIR_EXTENTION)
    RELEASE_WD_DIR_NAME=S390XReleaseWD$(DIR_EXTENTION)
    DEBUG_DIR_NAME=S390XDebug$(DIR_EXTENTION)
    RELEASE_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release/S390X$(DIR_EXTENTION)
    RELEASE_WD_BIN_DIR_NAME=$(ROOTDIR)/../../bin/linux/release_debug_info/S390X$(DIR_EXTENTION)
    DEBUG_DIR_BIN_NAME=$(ROOTDIR)/../../bin/linux/debug/S390X$(DIR_EXTENTION)
endif

ifdef RELEASE
    OUTDIR=$(ROOTDIR)/$(RELEASE_DIR_NAME)
    INTDIR=$(ROOTDIR)/$(RELEASE_DIR_NAME)
    BIN_DIR_NAME=$(RELEASE_BIN_DIR_NAME)
else
ifdef RELEASE_WD
    OUTDIR=$(ROOTDIR)/$(RELEASE_WD_DIR_NAME)
    INTDIR=$(ROOTDIR)/$(RELEASE_WD_DIR_NAME)
    BIN_DIR_NAME=$(RELEASE_WD_BIN_DIR_NAME)
else
    OUTDIR=$(ROOTDIR)/$(DEBUG_DIR_NAME)
    INTDIR=$(ROOTDIR)/$(DEBUG_DIR_NAME)
    BIN_DIR_NAME=$(DEBUG_DIR_BIN_NAME)
endif
endif

# Martini-specific defines
DEFINES += -DLIN -D_UNIX_ -DMARTINI_JIE 

CPP_LINK_EXEC = $(CPP_LINKER) 
C_LINK = $(C_LINKER) -shared
C_LINK_EXEC = $(C_LINKER)

ifdef MVS_COMPILER
	STATIC_COMPILE = ar crs $@ $(OBJS)
endif

ifdef SOLARIS_COMPILER
	STATIC_COMPILE = CC -xar -o $@ $(OBJS)
endif
ifdef SOLARISX86_COMPILER
	ifdef SIXTYFOURBIT
		STATIC_COMPILE = CC -xarch=amd64 -xar -o $@ $(OBJS)
	else
		STATIC_COMPILE = CC -xar -o $@ $(OBJS)
	endif
	
endif

ifdef AIX_COMPILER
	ifdef SIXTYFOURBIT
	    STATIC_COMPILE = ar -X64 crs $@ $(OBJS)
	else
	    STATIC_COMPILE = ar -X32 crs $@ $(OBJS)
	endif
endif
ifdef LINUX_GCC_COMPILER
	STATIC_COMPILE = ar crs $@ $(OBJS)
endif

# Martini-specific linker options: statically link with libstdc++ on IPF and IA32,
# dynamic link on EM64T, S390X
ifdef EM64T
	STD_LIBS = -fPIC
	CPP_LINK = $(CPP_LINKER) -shared
	VER_SCR =
endif
ifdef MVS
	STD_LIBS = -W l,$(SIXTYFOURBIT)DLL,XPLINK,AMODE=$(AMODEBIT),RMODE=ANY,CALL,REUS=RENT
	CPP_LINK = $(CPP_LINKER)
	VER_SCR =
endif
ifdef SOLARIS
	ifdef SIXTYFOURBIT
		LIBLOCATION = -L/usr/lib/sparcv9 -L/usr/local/lib/sparcv9/lib -R /usr/lib/64
		LINKFLAGS = -xtarget=ultra -xarch=v9
	else
		LIBLOCATION = -L/usr/lib -L/usr/local/lib -R /usr/local/lib
	endif

	STD_LIBS = -KPIC -lCstd -lCrun $(LIBLOCATION)
	CPP_LINK = $(CPP_LINKER) $(LINKFLAGS) -G -mt $(LIBLOCATION)
	VER_SCR =
endif
ifdef SOLARISX86
	ifdef SIXTYFOURBIT
		LIBLOCATION = -L/usr/lib/amd64
		LINKFLAGS = -xarch=amd64 
	else	
		LIBLOCATION = -L/usr/lib
	endif

	STD_LIBS = -KPIC -lCstd -lCrun $(LIBLOCATION)
	CPP_LINK = $(CPP_LINKER) $(LINKFLAGS) -G -mt $(LIBLOCATION)
	VER_SCR =
endif
ifdef S390X
	# use similar settings to EM64T
	STD_LIBS = -fPIC
	CPP_LINK = $(CPP_LINKER) -shared -m64 -L$(UUID_LIB_DIR)
	VER_SCR =
endif
ifdef S390
	STD_LIBS = -fPIC
	CPP_LINK = $(CPP_LINKER) -shared -m31 -Wall -L$(UUID_LIB_DIR)
	VER_SCR =
endif
ifdef IPF
	# IPF: assume gcc 3.2.3 or above, therefore need to statically link libgcc
	# in addition to libstdc++. This is not needed when using gcc 2.96
	STD_LIBS = -fPIC -Wl,-Bstatic -lstdc++ -static-libgcc -Wl,-Bdynamic
	VER_SCR = -Wl,--version-script=$(VER_FILE)
	CPP_LINK = $(C_LINKER) -shared
endif
ifdef IA32
		STD_LIBS = -fPIC -Wl,-Bstatic -lstdc++ -Wl,-Bdynamic
		VER_SCR = -Wl,--version-script=$(VER_FILE)
		CPP_LINK = $(C_LINKER) -m32 -shared
endif
ifdef AIX
	  STD_LIBS = -qpic=large 
	  CPP_LINK = $(CPP_LINKER) -G

	ifdef SIXTYFOURBIT
	    CPP_LINK += -q64
	else
	    CPP_LINK += -q32
	endif

#	  CPP_LINK = $(CPP_LINKER) -G -brtl -bexpall -qmkshrobj -q64 -D_EM64T_ 
endif


ifdef IPF
	DEFINES += -DIPF_ARCH 
	PLATFORM_NAME=IPF
endif
ifdef MVS
    DEFINES += -DMVS
    ifdef SIXTYFOURBIT
        PLATFORM_NAME=zOS64
    else
        PLATFORM_NAME=zOS
    endif
endif
ifdef S390X
	DEFINES += -DS390X_ARCH	-D_LINUX_390 -DPOSIX -DHAVE_RPATH
	PLATFORM_NAME=S390X
endif
ifdef S390
	DEFINES += -DS390_ARCH	-D_LINUX_390 -DPOSIX -DHAVE_RPATH
	PLATFORM_NAME=S390
endif
ifdef EM64T
	DEFINES += -DEM64T_ARCH
	PLATFORM_NAME=EM64T
endif
ifdef SOLARIS
	ifndef SIXTYFOURBIT
		PLATFORM_NAME = SPARC
	else
		PLATFORM_NAME = SPARC-V9
	endif
	DEFINES += -DSOLARIS_ARCH -D_SOLARIS -DHAVE_RPATH
endif
ifdef SOLARISX86
    DEFINES += -DSOLARIS_ARCH -D_SOLARISX86 -DHAVE_RPATH
    ifdef SIXTYFOURBIT
        PLATFORM_NAME=SOLARIS-X64
    else
        PLATFORM_NAME=SOLARIS-X86
    endif
endif
ifdef IA32
	DEFINES += -DIA32_ARCH
	PLATFORM_NAME=IA-32
endif
ifdef AIX
    DEFINES += -DPPC_ARCH
	ifdef SIXTYFOURBIT
		PLATFORM_NAME=AIX-PPC64
	else
		PLATFORM_NAME=AIX-PPC
	endif
endif
ifdef LINUX
    DEFINES += -DHAVE_RPATH
endif

ifdef RELEASE
    OBJDIR = release/$(PLATFORM_NAME)$(DIR_EXTENTION)
    OUTDIR = $(ROOTDIR)/bin/linux/release/$(PLATFORM_NAME)$(DIR_EXTENTION)
    PLATFORM_AND_MODE_NAME = release/$(PLATFORM_NAME)
else
    ifdef RELEASE_WD
        OBJDIR = release_debug_info/$(PLATFORM_NAME)$(DIR_EXTENTION)
        OUTDIR = $(ROOTDIR)/bin/linux/release_debug_info/$(PLATFORM_NAME)$(DIR_EXTENTION)
	    PLATFORM_AND_MODE_NAME = release_debug_info/$(PLATFORM_NAME)
    else
        OBJDIR = debug/$(PLATFORM_NAME)$(DIR_EXTENTION)
        OUTDIR = $(ROOTDIR)/bin/linux/debug/$(PLATFORM_NAME)$(DIR_EXTENTION)
	    PLATFORM_AND_MODE_NAME = debug/$(PLATFORM_NAME)
    endif
endif

