/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BIRTPlugin.java,v 1.1 2006/08/28 04:26:09 sleeloy Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class BIRTPlugin extends Plugin{

	public static final String PLUGIN_ID = "org.eclipse.tptp.platform.report.birt.ui"; //$NON-NLS-1$
	//The shared instance.
	private static BIRTPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public BIRTPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);		
	}

	
	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}
	

	/**
	 * Returns the shared instance.
	 */
	public static BIRTPlugin getDefault() {
		return plugin;
	}


	/**
	 * Logs an error described by a throwable.
	 * 
	 * <p>This method should be used whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param throwable
	 */
	public static void logError(Throwable exc)
	{
		Status status = new Status(1, getID(), 0, exc.toString(), exc);
		getDefault().getLog().log(status);
	}
	
	/**
	 * Returns this plugin's id.
	 * @return String
	 */
	public static String getID()
	{
		return PLUGIN_ID;
	}
}
