/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BIRTResourceLocator.java,v 1.5 2009/04/28 19:47:24 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

import java.net.URL;
import java.util.Map;

import org.eclipse.birt.report.model.api.DefaultResourceLocator;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;

/**
 * <p>Resource locator that will search the class path for <code>.properties</code> files.</p>
 * 
 * @author  Paul Slauenwhite
 * @version April 28, 2009
 * @since   May 11, 2006
 */
public class BIRTResourceLocator implements IResourceLocator {

	protected Class bundle;
	
	protected IResourceLocator defaultLocator = new DefaultResourceLocator();
	
	public BIRTResourceLocator(Class bundle) {
		super();
		this.bundle = bundle;
	}

	public Class getBundle() {
		return bundle;
	}

	public void setBundle(Class bundle) {
		this.bundle = bundle;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.api.IResourceLocator#findResource(org.eclipse.birt.report.model.api.ModuleHandle, java.lang.String, int)
	 */
	public URL findResource(ModuleHandle module, String filename, int type) {
		switch (type){
			case IResourceLocator.CASCADING_STYLE_SHEET:
			case IResourceLocator.IMAGE:
			case IResourceLocator.LIBRARY:
				return defaultLocator.findResource(module, filename, type);
			default:
				return(bundle.getResource(filename));
					
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.birt.report.model.api.IResourceLocator#findResource(org.eclipse.birt.report.model.api.ModuleHandle, java.lang.String, int, java.util.Map)
	 */
	public URL findResource(ModuleHandle module, String filename, int type, Map appContext) {
		return (findResource(module, filename, type));
	}
}
