/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HtmlSortWrapper.java,v 1.7 2009/03/16 17:18:18 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

/**
 * <p>BIRTReportGenerator provides an entry point to generate BIRT reports based on 
 * BIRT report template design files.</p>
 * 
 * <p>This class provides method that takes in a IReportElement object that contains 
 * the template file, data source and output stream to generate the HTML report.</p>
 * 
 * 
 * @author  Sheldon Lee-Loy
 * @author  Paul E. Slauenwhite
 * @version March 16, 2009
 * @since   March 24, 2006
 * @see     org.eclipse.tptp.platform.report.core.provisional.IReportElement.
 */
public class HtmlSortWrapper {

	private static StringBuffer headerPartOne = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n").
	append("<html>\n").
	append("		<head>\n").
	append("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n").
	append("	    <script language=\"JavaScript1.3\">\n").
	append("	      <!--\n").
	append("	      function initialize(windowDocument,windowLabel) {\n").
	append("	        if (windowDocument.getElementsByTagName){\n").
	append("	          var tables = windowDocument.getElementsByTagName(\"table\");\n").
	append("	          for (var counter = 0;counter < tables.length;counter++){\n").
	append("	            if((tables[counter].id.indexOf(\"sortable\") != -1) && (tables[counter].id)){\n").
	append("	              if ((tables[counter].rows) && (tables[counter].rows.length > 0)){\n").
	append("	                var firstRow = tables[counter].rows[0];\n").
	append("	                for (var counter2 = 0;counter2 < firstRow.cells.length;counter2++){\n").
	append("	                  var cell = firstRow.cells[counter2];\n").
	append("	                  cell.innerHTML = '<font face=\"arial\">&nbsp;</font>' + getCellText(cell) + '<a style=\"text-decoration: none;\" href=\"#\" onclick=\"' + windowLabel + '.resortTable(this);return false;\"><span class=\"sortArrow\" style=\"text-decoration: none; color: black;\"><img border=\"0\" src=\"");

	private static StringBuffer headerPartTwo = new StringBuffer("/arrow.gif\"/></span></a>';\n").
	append("	                }\n").
	append("}\n").
	append("	            }\n").
	append("	          }\n").
	append("	        }\n").
	append("	      }\n").
	append("	      function getCellText(cell){\n").
	append("if ((typeof cell == \"string\") || (typeof cell == \"undefined\")){\n").
	append("	          return cell;\n").
	append("	        }\n").
	append("	        else if (cell.innerText){\n").
	append("	          return cell.innerText;\n").
	append("	        }\n").
	append("	        var cellText = \"\";\n").	
	append("	        var childNodes = cell.childNodes;\n").
	append("	        for (var counter = 0;counter < childNodes.length;counter++){\n").
	append("	          if(childNodes[counter].nodeType == 1){\n").
	append("	            cellText += getCellText(childNodes[counter]);\n").
	append("	          }\n").
	append("	          else if(childNodes[counter].nodeType == 3){\n").
	append("	            cellText += childNodes[counter].nodeValue;\n").
	append("	          }\n").
	append("	        }\n").
	append("return cellText;\n").
	append("	      }\n").
	append("	      function getSortableCellText(cell){\n").
	append("	        var cellText = getCellText(cell).toLowerCase();\n").
	append("	        cellText = cellText.replace(/^\\s+/g, \"\");\n").
	append("	        cellText = cellText.replace(/\\s+$/g, \"\");\n").
	append("	        if ((cellText.match(/^[\\d\\.]+\\s*\\t*\\r*\\n*$/)) || (cellText.match(/^[\\d\\.]+%\\s*\\t*\\r*\\n*$/))){\n").
	append("	          cellText = parseFloat(cellText);\n").
	append("	          if(isNaN(cellText)){\n").
	append("	            cellText = 0;\n").
	append("	          }\n").
	append("	        }\n").
	append("	        return cellText;\n").
	append("	      }\n").
	append("	      function getParentNode(cell, parentTagName){\n").
	append("	        if (cell != null){\n").
	append("	          if((cell.nodeType == 1) && (cell.tagName.toLowerCase() == parentTagName.toLowerCase())){\n").
	append("	            return cell;\n").
	append("	          }\n").
	append("	          return (getParentNode(cell.parentNode, parentTagName));\n").
	append("	        }\n").
	append("	        return null;\n").
	append("	      }\n").
	append("	      function getChildNode(cell, childTagName){\n").
	append("	        if (cell != null){\n").
	append("	          for (var counter = 0;counter < cell.childNodes.length;counter++){\n").
	append("	            if ((cell.childNodes[counter].nodeType == 1) && (cell.childNodes[counter].tagName.toLowerCase() == childTagName.toLowerCase())){\n").
	append("	              return (cell.childNodes[counter]);\n").
	append("	            }\n").
	append("	            else{\n").
	append("	              var childNode = getChildNode(cell.childNodes[counter],childTagName);\n").
	append("	              if(childNode != null){\n").
	append("	                return childNode;	\n").
	append("	              }\n").
	append("	            }\n").
	append("	          }\n").
	append("	        }\n").
	append("	        return null;\n").
	append("	      }\n").
	append("	      function resortTable(anchor){\n").
	append("	        var table = getParentNode(anchor.parentNode,'TABLE');\n").
	append("	        if (table.rows.length > 1){ \n").
	append("	          var selectedColumnIndex = anchor.parentNode.cellIndex;\n").            
	append("	          var sortableRows = new Array();\n").
	append("	          var sortableRowsColor = new Array();\n").
	append("	          var bottomRows = new Array();\n").
	append("	          for (var counter = 1;counter < table.rows.length;counter++){\n").
	append("	            if ((table.rows[counter].id) && (table.rows[counter].id.indexOf('sortableBottomRow') != -1)){\n").
	append("	              bottomRows[bottomRows.length] = table.rows[counter];\n").
	append("	            }\n").
	append("	            else{\n").
	append("	              sortableRows[sortableRows.length] = table.rows[counter]; \n").
	append("	              sortableRowsColor[sortableRowsColor.length] = table.rows[counter].bgColor;\n").
	append("	            }      \n").
	append("	          }\n").
	append("	          var span = getChildNode(anchor,'span');\n").
	append("	          if(span.getAttribute(\"sortDirection\") == 'up'){\n").
	append("	            sortableRows.reverse();	       \n").
	append("	            span.innerHTML = '<img border=\"0\" src=\"");
	
	private static StringBuffer headerPartThree = new StringBuffer("/darrow.gif\"/>';\n").     
	append("	            span.setAttribute('sortDirection','down');\n").
	append("	          } \n").
	append("	          else {\n").
	append("	            if(span.getAttribute(\"sortDirection\") == 'down'){\n").
	append("	              sortableRows.reverse();	       \n").
	append("	            }\n").
	append("	            else{\n").    
	append("	              for (var counter = 1; counter < sortableRows.length; counter++){\n").
	append("	                var currentRow = sortableRows[counter];\n").
	append("	                var sortedCellText = getSortableCellText(currentRow.cells[selectedColumnIndex]);\n").
	append("	                var index = counter;\n").
	append("	                while ((index > 0) && (getSortableCellText(sortableRows[index - 1].cells[selectedColumnIndex]) > sortedCellText)){\n").
	append("	                  sortableRows[index] = sortableRows[index - 1];\n").
	append("	                  index--;\n").
	append("	                }\n").
	append("	                sortableRows[index] = currentRow;\n").
	append("	              }\n").
	append("	            }\n").
	append("	            span.innerHTML = '<img border=\"0\" src=\"");
	
	private static StringBuffer headerPartFour = new StringBuffer("/uarrow.gif\"/>';\n").
	append("	            span.setAttribute('sortDirection','up');\n").
	append("	          }\n").
	append("	          for (var counter = 0;counter < sortableRows.length;counter++){\n").
	append("	            sortableRows[counter].bgColor = sortableRowsColor[counter];\n"). 
	append("	            table.tBodies[0].appendChild(sortableRows[counter]);\n").
	append("	          }\n").
	append("	          for (var counter = 0;counter < bottomRows.length;counter++){\n").     
	append("	            table.tBodies[0].appendChild(bottomRows[counter]);\n").
	append("	          }\n").
	append("	          for (var counter = 0;counter < table.rows[0].cells.length;counter++){\n").
	append("	            if(counter != selectedColumnIndex){         \n").
	append("	              var span = getChildNode(table.rows[0].cells[counter],'span');\n").
	append("	              span.innerHTML = '<img border=\"0\" src=\"");
	
	private static StringBuffer headerPartFive = new StringBuffer("/arrow.gif\"/>';\n").
	append("	              span.setAttribute('sortDirection','');\n").
	append("	            }\n").
	append("	          }    \n").
	append("	        }\n").
	append("	      }\n").
	append("	      // -->\n").
	append("	    </script>\n").
	append("		</head>\n").
	append("		<body class=\"style_0\" onload=\"initialize(window.document,'window');\">\n");

	public static String getHeader(String imageDirectory){
		return (headerPartOne.toString().concat(imageDirectory).concat(headerPartTwo.toString()).concat(imageDirectory).concat(headerPartThree.toString()).concat(imageDirectory).concat(headerPartFour.toString()).concat(imageDirectory).concat(headerPartFive.toString()));
	}

	public static String getFooter(){
		return ("</html>\n");
	}	

}
