/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IBIRTConstants.java,v 1.2 2006/09/08 21:30:35 sleeloy Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

public interface IBIRTConstants {
	/**
	 * Context property that represents the location of any images associated with the report
	 */
	public static String CONTEXT_IMG_DIR = "CONTEXT_IMG_DIR";
	/**
	 * Output stream that is used to write the report to.
	 */
	public static String CONTEXT_OUTSTREAM = "CONTEXT_OUTSTREAM";
	/**
	 * Output folder that specifies where to store the report
	 */
	public static String CONTEXT_OUT_FOLDER = "CONTEXT_OUT_FOLDER";
	/**
	 * Output file that specifies where to save the report
	 */
	public static String CONTEXT_OUT_FILE = "CONTEXT_OUT_FILE";
	
	/**
	 * Birt resource locator object that implements org.eclipse.birt.report.model.api.IResourceLocator.  This class is used to 
	 * lookup externalized strings in the report
	 */
	public static String CONTEXT_RESOURCE_LOCATOR = "CONTEXT_RESOURCE_LOCATOR";
	/**
	 * Represents the BIRT template file
	 */
	public static String CONTEXT_TEMPLATE_FILE = "CONTEXT_TEMPLATE_FILE";
	
	/**
	 * Represents a child BIRT template file 
	 */
	public static String CONTEXT_CHILD_TEMPLATEFILE = "CONTEXT_CHILD_TEMPLATEFILE";
	
	/**
	 * Determines if any tables in the template file should support sorting
	 */
	public static String CONTEXT_SORTABLE = "CONTEXT_SORTABLE";

	/**
	 * A message bundle that contains the extenalized strings.  This property can be set instead of the CONTEXT_RESOURCE_LOCATOR property. 
	 */
	public static String CONTEXT_MSG_BUNDLE = "CONTEXT_MSG_BUNDLE";
	
	/**
	 * Determines if the generated output should be generated as an embedded page.  That is, no html header tags will be emitted.
	 * Valid values are Boolean.TRUE or Boolean.FALSE
	 * 
	 */
	public static String CONTEXT_EMBEDDED = "CONTEXT_EMBEDDED";
	
	/**
	 * Indicates the file path location of the BIRT report engine.  This is only used when generating reports outside the eclipse environment.
	 */
	public static String CONTEXT_BIRT_HOME = "CONTEXT_BIRT_HOME";
}
