/**********************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportElementExtensionRegistryReader.java,v 1.3 2009/05/17 16:16:35 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.provisional.IOperationContext;
import org.eclipse.tptp.platform.report.birt.core.BIRTPlugin;
import org.eclipse.tptp.platform.report.birt.core.provisional.IReportElement;
import org.osgi.framework.Bundle;

/**
 * <p>ReportElementExtensionRegistryReader.java</p>
 * 
 * 
 * @author     Paul E. Slauenwhite
 * @version    May 16, 2009
 * @since      August 28, 2006
 */
public class ReportElementExtensionRegistryReader {
    public static final String PLUGIN_POINT = "reportElement"; //$NON-NLS-1$
    public static final String REPORTELEMENT = "reportElement"; //$NON-NLS-1$
    public static final String ID = "id"; //$NON-NLS-1$
    public static final String NAME = "name"; //$NON-NLS-1$
    public static final String VALUE = "value"; //$NON-NLS-1$
    public static final String TYPE = "type"; //$NON-NLS-1$
    public static final String PROPERTY = "property"; //$NON-NLS-1$
    public static final String CLASSPROPERTY = "classProperty"; //$NON-NLS-1$
    public static final String DESCRIPTION = "description"; //$NON-NLS-1$
    public static final String CLASS = "class"; //$NON-NLS-1$
    private static ReportElementExtensionRegistryReader instance = null;
    
    public static ReportElementExtensionRegistryReader getInstance() {
        if (instance == null) {
            instance = new ReportElementExtensionRegistryReader();
        }
        return instance;
    }

    private List reportElements;

    private ReportElementExtensionRegistryReader() {
    	reportElements = new LinkedList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(BIRTPlugin.getDefault().getBundle().getSymbolicName(), PLUGIN_POINT);
        if (point == null) return;
        IExtension[] extensions = point.getExtensions();
        try {
            for (int i = 0; i < extensions.length; i++) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                for (int j = 0; j < elements.length; j++) {
                    if (elements[j].getName().equals(REPORTELEMENT)) {
                        reportElements.add(elements[j]);
                    }
                }
            }
        } catch (Exception e) {
        	BIRTPlugin.logError(e);
        }
    }
    
    public IReportElement createReportElement(String id){
    	if (id == null) return null;
    	for (int x = 0; x <reportElements.size(); x++){
    		IConfigurationElement configElem = (IConfigurationElement)reportElements.get(x);
    		if (id.equals(configElem.getAttribute(ID))){
    			try {
					IReportElement elem = (IReportElement)configElem.createExecutableExtension(CLASS);
					IConfigurationElement[] children = configElem.getChildren(PROPERTY);
					IOperationContext context = elem.getContext();
					for (int y = 0; y < children.length; y++){
						IConfigurationElement child = children[y];
				        final String plugin = child.getContributor().getName();
				        final Bundle bundle = Platform.getBundle( plugin );
						String value = child.getAttribute(VALUE);
						String key = child.getAttribute(NAME);
						//Should create BIRTResourceLocator that will use the bundle class
						if ((key.equals(IBIRTConstants.CONTEXT_TEMPLATE_FILE)) || (key.equals(IBIRTConstants.CONTEXT_CHILD_TEMPLATEFILE))){
					        final URL url = FileLocator.find( bundle, new Path( value ), null );
					        context.setProperty(key, url);
							
						}
						else{
							if ( value != null){
								context.setProperty(key, value);			
							}
							
						}
					}
					children = configElem.getChildren(CLASSPROPERTY);
					for (int y = 0; y < children.length; y++){
						IConfigurationElement child = children[y];
						String key = child.getAttribute(NAME);
						if (key.equals(IBIRTConstants.CONTEXT_RESOURCE_LOCATOR)){
							Object locator = configElem.createExecutableExtension(CLASS);
							context.setProperty(key, locator);
						}			
						else if (key.equals(IBIRTConstants.CONTEXT_MSG_BUNDLE)){
							Object clazz = configElem.createExecutableExtension(CLASS);
							BIRTResourceLocator locator = new BIRTResourceLocator(clazz.getClass());
							context.setProperty(IBIRTConstants.CONTEXT_RESOURCE_LOCATOR, locator);
						}
					}
					
					return elem;
				} catch (InvalidRegistryObjectException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (CoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
    			
    		}
    	}
    	return null;
    	
    }
    
	
    
    public List getWizardCategoryElements() {
        return reportElements;
    }

}
