/*******************************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportElementImpl.java,v 1.10 2008/01/24 19:00:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tptp.platform.common.provisional.EclipseOperationStatus;
import org.eclipse.tptp.platform.common.provisional.IOperationContext;
import org.eclipse.tptp.platform.report.birt.core.BIRTPlugin;
import org.eclipse.tptp.platform.report.birt.core.provisional.BIRTReportGenerator;
import org.eclipse.tptp.platform.report.birt.core.provisional.IReportElement;

public class ReportElementImpl implements IReportElement {
	protected InputStream dataSource;
	protected OutputStream outputStream;
	protected List content;
	protected List childElements;
	protected IOperationContext context;
	protected String rootFile;
	public String getRootFile() {
		return rootFile;
	}
	public void setRootFile(String rootFile) {
		this.rootFile = rootFile;
	}
	public ReportElementImpl() {
		super();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.birt.core.internal.impl.IReportElement#getTemplateFile()
	 */
	public InputStream getTemplateFile() {
		Object templateFile = context.getProperty(IBIRTConstants.CONTEXT_TEMPLATE_FILE);
		try {
			if (templateFile instanceof URL){
				return ((URL)templateFile).openStream();
			}
			else if (templateFile instanceof InputStream)
				return (InputStream)templateFile;
			else if (templateFile instanceof String){
				return new FileInputStream(new File((String)templateFile));
			}
		} catch (IOException e) {
			Status status = new Status(IStatus.ERROR,BIRTPlugin.PLUGIN_ID,Status.ERROR,e.getMessage(), e);
			context.setStatus(new EclipseOperationStatus(status));
		}
		return null;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.birt.core.internal.impl.IReportElement#setTemplateFile(java.io.InputStream)
	 */
	public void setTemplateFile(InputStream templateFile) {
		context.setProperty(IBIRTConstants.CONTEXT_TEMPLATE_FILE, templateFile);
	}
	public OutputStream getOutputStream() {
		Object out = context.getProperty(IBIRTConstants.CONTEXT_OUTSTREAM);
		if (out != null){
		try {
			if (out instanceof OutputStream)
				return (OutputStream)out;
			else if (out instanceof String){
				return new FileOutputStream(new File((String)out));
			}
		} catch (IOException e) {
			Status status = new Status(IStatus.ERROR,BIRTPlugin.PLUGIN_ID,Status.ERROR,e.getMessage(), e);
			context.setStatus(new EclipseOperationStatus(status));
		}
		}
		else{
			String outputFolder = (String) context.getProperty(IBIRTConstants.CONTEXT_OUT_FOLDER); 
			if (outputFolder != null){
				rootFile = (String) context.getProperty(IBIRTConstants.CONTEXT_OUT_FILE);
				if (rootFile == null)
					rootFile = "index.html";
	    		try {
					return new FileOutputStream(outputFolder + File.separator +rootFile);
				} catch (FileNotFoundException e) {
					Status status = new Status(IStatus.ERROR,BIRTPlugin.PLUGIN_ID,Status.ERROR,e.getMessage(), e);
					context.setStatus(new EclipseOperationStatus(status));
				} 
			}
			
		}
		return null;
	}
	public void setOutputStream(OutputStream outputStream) {
		context.setProperty(IBIRTConstants.CONTEXT_OUTSTREAM, outputStream);
	}
	public InputStream getDataSource() {
		return dataSource;
	}
	public void setDataSource(InputStream dataSource) {
		this.dataSource = dataSource;
	}
	
	public List getChildElements() {
		if (childElements == null)
			childElements = new ArrayList();
		return childElements;
	}
	public List getContent() {
		return content;
	}
	public void setContent(List content) {
		this.content = content;
	}
	public boolean isEmbedded() {
		Object embedded = context.getProperty(IBIRTConstants.CONTEXT_EMBEDDED);
		if (embedded instanceof Boolean){
			return ((Boolean)embedded).booleanValue();
		}		
		return false;
	}
	public void setEmbedded(boolean embedded) {
		context.setProperty(IBIRTConstants.CONTEXT_EMBEDDED, new Boolean(embedded));
	}
	public boolean isSortable() {
		Object sortable = context.getProperty(IBIRTConstants.CONTEXT_SORTABLE);
		if (sortable instanceof Boolean){
			return ((Boolean)sortable).booleanValue();
		}		
		return true;
	}
	public void setSortable(boolean sortable) {
		context.setProperty(IBIRTConstants.CONTEXT_SORTABLE, new Boolean(sortable));
	}
	public void initialize() {
	}
	public IOperationContext getContext() {
		return context;
	}
	public void setContext(IOperationContext context) {
		this.context = context;
	}
	
	protected String getImageDir(){
		String imgDir = (String)context.getProperty(IBIRTConstants.CONTEXT_IMG_DIR);
		//make image directory the same as the output folder if not defined
		if (imgDir == null)
			imgDir = "";
		return imgDir;
	}
	
	public void generate(){
		
		//generate root index report
		String imgDir = getImageDir();
		//make image directory the same as the output folder if not defined
		if (imgDir == null)
			imgDir = ""; 
		
		String birtHome = (String) context.getProperty(IBIRTConstants.CONTEXT_BIRT_HOME);
		InputStream in = null;
		InputStream templateFile = null;
		BIRTResourceLocator resourceLocator = (BIRTResourceLocator)context.getProperty(IBIRTConstants.CONTEXT_RESOURCE_LOCATOR);
		
		//get output file name
		String outputFolder = (String) context.getProperty(IBIRTConstants.CONTEXT_OUT_FOLDER); 
		if (outputFolder != null){
			rootFile = (String) context.getProperty(IBIRTConstants.CONTEXT_OUT_FILE);
			if (rootFile == null)
				rootFile = "index.html";
		}
    	try {    		
    		in = getDataSource();
    		templateFile = getTemplateFile();
    		BIRTReportGenerator generator = BIRTReportGenerator.getInstance();
    		generator.setBirtHome(birtHome);
    		generator.generateHTMLReport(getOutputStream(), templateFile, in, isSortable(), imgDir, outputFolder, resourceLocator);
		} catch (Exception e) {
			Status status = new Status(IStatus.ERROR,BIRTPlugin.PLUGIN_ID,Status.ERROR," ", e);
			context.setStatus(new EclipseOperationStatus(status));
		}		
		finally{
			if (in != null){
				try {
					in.close();
				} catch (IOException e) {
				}		
			}
			if (templateFile != null){
				try {
					templateFile.close();
				} catch (IOException e) {
				}		
			}
		}		
	}
	
}
