/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TPTPImageHandler.java,v 1.2 2006/12/14 16:05:53 sleeloy Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

import java.io.File;

import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.IImage;

public class TPTPImageHandler extends HTMLCompleteImageHandler {


	/**
	 * Need to create a custom handle image since birt will prepend an absolute path instead of a relative path.
	 */
	protected String handleImage( IImage image, Object context, String prefix,
			boolean needMap )
	{
		String outFile = super.handleImage(image, context, prefix, needMap);

		if ( context != null && ( context instanceof TPTPHTMLRenderContext ) )
		{
			String imageDirectory = null;
			TPTPHTMLRenderContext myContext = (TPTPHTMLRenderContext) context;
			imageDirectory = myContext.getTptpImageDir();
			if (outFile != null){
				File oldFile = new File(outFile);
				if ((imageDirectory != null) && (imageDirectory.trim().length() > 0))
					outFile = imageDirectory + File.separator + oldFile.getName();
				else
					outFile = oldFile.getName();
			}
		}

		
		return outFile;
	}	

}
