/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BIRTUtil.java,v 1.2 2006/05/16 13:57:04 sleeloy Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.provisional;

/**
 * A utility class that provides helper functions to the BIRT reporting framework.
 */
public class BIRTUtil {
	
	/**
	 * Checks if BIRT is installed in the applicaiton environment
	 * @return true if BIRT is installed otherwise false is returned
	 */
	public static boolean checkBIRT(){
		try {
			Class.forName("org.eclipse.birt.report.engine.api.IReportEngine"); //$NON-NLS-1$
		} catch (ClassNotFoundException e) {
			return false;
		}
		return true;
	}
}
