/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IReportElement.java,v 1.3 2006/08/28 04:26:08 sleeloy Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.report.birt.core.provisional;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import org.eclipse.tptp.platform.common.provisional.IOperationContext;

/**
 * IReportElement provides the necessary information needed by the report generator to create static html reports.
 * A report element is composed of essential three parts:
 * <p>
 * datasource - an input stream that contains the raw data to generate the report.  Note the type of datasource
 *              (ie. xml, csv, etc) should be the expected data source needed by the report template file.
 * template file - the BIRT template file that contains the cosmetic information and layout information of the report.
 * output stream - the stream to write the resulting html text to.
 *</p>
 *
 * Note that a report element can contain children report elements.  The repoprt generator will first generate the report 
 * associated with the root report element and then process the children report elements.  
 */
public interface IReportElement {

	/**
	 * Returns the input stream that contains the raw data to generate the report.  Note the type of datasource
	 * (ie. xml, csv, etc) should be the expected data source needed by the report template file.
	 * @return an input stream representing the raw data
	 * @deprecated
	 */
	public abstract InputStream getDataSource();

	/**
	 * Sets the input stream that represents the raw data.
	 * @param dataSource the input stream that represents the raw data.
	 * @deprecated
	 */
	public abstract void setDataSource(InputStream dataSource);

	/**
	 * Returns the input stream that contains the BIRT template file.
	 * @deprecated
	 * @return the input stream that contains the BIRT template file.
	 */
	public abstract InputStream getTemplateFile();

	/**
	 * Sets the input stream that contains the BIRT template file.
	 * @param templateFile the input stream that contains the BIRT template file.
	 * @deprecated
	 */
	public abstract void setTemplateFile(InputStream templateFile);
	
	/**
	 * Returns the output stream containing the resulting HTML content.
	 * @return the output stream containing the resulting HTML content.
	 */
	public abstract OutputStream getOutputStream();
	
	/**
	 * Sets the output stream containing the resulting HTML content.
	 * @param out the output stream containing the resulting HTML content.
	 */
	public abstract void setOutputStream(OutputStream out);
	
	/**
	 * A list of child report elements.   The list should contain a list of object of type IReportElement.
	 * @return a list of  child report elements.
	 */
	public abstract List getChildElements();

	/**
	 * Determins if the generated HTML output should embed javascript to sort table columns.  If true javascript
	 * will be embedded in the resulting html report to sort columns in tables.  Note the table id in the report
	 * template must be set to 'sortable'.
	 * 
	 * @return true if the generated HTML output will sort table columns
	 * @deprecated
	 */
	public abstract boolean isSortable();

	/**
	 * Sets whether the generated HTML output should contain javascript to sort table columns.  
	 * Note the table id in the report template file must be set to 'sortable'.
	 * @param sortable set whether the generated HTML output should contain javascript to sort table columns.
	 * @deprecated
	 */
	public abstract void setSortable(boolean sortable);
	
	/**
	 * Determines if the generated HTML output should generate head or body tags.  If true the resulting html output
	 * will not contain head or body tags.
	 * @return true if the resulting html output will contain head or body tags otherwise false is returned.
	 * @deprecated
	 */
	public abstract boolean isEmbedded();
	
	/**
	 * Sets if the generated HTML output should generate head or body tags.  If true the resulting html output
	 * will not contain head or body tags.
	 * @param embedded true if the resulting html output should contain head or body tags.
	 * @deprecated
	 */
	public abstract void setEmbedded(boolean embedded);

	/**
	 * Returns the context object used to pass in report configuration information
	 * 
	 * @return the context object used to pass in report configuration information
	 */
	public abstract IOperationContext getContext();
	
	/**
	 * Sets the context object used to pass in report configuration information
	 * @param context the context object used to pass in report configuration information
	 */
	public abstract void setContext(IOperationContext context);	
	/**
	 * Initializes the state of the report element object before generating the report.
	 *
	 */
	public abstract void initialize();
	
	public abstract void generate();
	
}