/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal;



/**
 * Constants for storing TI specific options/parameters in an <code>
 * ILaunchConfiguration</code>.
 * 
 * @author Ali Mehregani
 */
public class ITILaunchConfigurationConstants 
{
	/**
	 * A <code>String</code> containing the filter set id
	 */
	public static final String ATTR_FILTERSET_ID = TIPlugin.getId() + ".ATTR_FILTERSET_ID";
	
	
	/**
	 * A <code>boolean</code> indicating whether execution data should be collected.  If the value of 
	 * the attribute is set, then execution data will be on; otherwise
	 * execution data will be off.
	 */
	public static final String ATTR_EXEC_DATA = TIPlugin.getId() + ".ATTR_EXEC_DATA";
	
	
	/**
	 * A <code>boolean</code> indicating whether CPU time should be included or not.  CPU time
	 * is included if the flag is set; otherwise it will not be included.
	 */
	public static final String ATTR_EXEC_CPU_TIME = TIPlugin.getId() + ".ATTR_EXEC_CPU_TIME";

	/**
	 * A <code>boolean</code> indicating whether Object allocation informaton
	 * should be included or not. Object allocation informaton is included if
	 * the flag is set; otherwise it will not be included.
	 */
	public static final String ATTR_EXEC_OBJ_ALLOC_SITE = TIPlugin.getId() + ".ATTR_EXEC_OBJ_ALLOC_SITE";
	public static final String OPTION_ALLOC_SITE = "allocsites";
	
	/**
	 * A <code>boolean</code> indicating whether execution flow or execution statistics should
	 * be collected.  If the value of the attribute is set, then execution flow will be on; otherwise
	 * execution statistics will be on.
	 */
	public static final String ATTR_EXEC_FLOW = TIPlugin.getId() + ".ATTR_EXEC_FLOW";
	public static final String OPTION_EXEC_FLOW = "execdetails";

	/**
	 * A <code>boolean</code> indicating whether instance level information should be collected with
	 * execution statistics or execution flow data.  If the value of the attribute is set, then instance 
	 * level information is collected with execution data; otherwise instance level information will
	 * be turned off.
	 */
	public static final String ATTR_EXEC_COLLECT_INSTANCE = TIPlugin.getId() + ".ATTR_EXEC_COLLECT_INSTANCE";

	public static final String ATTR_EXEC_CONTENTION_ANALYSIS = TIPlugin.getId() + ".ATTR_EXEC_CONTENTION_ANALYSIS";

	/**
	 * A <code>boolean</code> indicating whether heap level information should be collected.  
	 * If the value of the attribute is set, then heap level information is collected; 
	 * otherwise heap level information will be turned off.
	 */
	public static final String ATTR_HEAP_DATA = TIPlugin.getId() + ".ATTR_HEAP_DATA";
	
	
	/**
	 * A <code>boolean</code> indicating whether instance level information should be collected with
	 * heap data.  If the value of the attribute is set, then instance level information is collected; 
	 * otherwise instance level information will be turned off.
	 */
	public static final String ATTR_HEAP_COLLECT_INSTANCE = TIPlugin.getId() + ".ATTR_HEAP_COLLECT_INSTANCE";

	/**
	 * A <code>boolean</code> indicating whether the polling frequency mode is
	 * automatic set to a constant. The flag is expected to be true if its
	 * automatically calculated.
	 */
	public static final String ATTR_EXEC_AUTO_POLLING = TIPlugin.getId() + ".ATTR_EXEC_AUTO_POLLING";
	
	/**
	 * A <code>boolean</code> indicating whether the polling frequency mode is
	 * manually set to a constant. The flag is expected to be true if it's
	 * manually set.
	 */
	public static final String ATTR_EXEC_MANUAL_POLLING = TIPlugin.getId() + ".ATTR_EXEC_MANUAL_POLLING";

	/**
	 * An <code>int</code> indicating the polling frequency period.
	 */
	public static final String ATTR_EXEC_POLLING_FREQ = TIPlugin.getId() + ".ATTR_EXEC_POLLING_TIME";
}
