/**********************************************************************
 * Copyright (c) 2006,2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal;

/**
 * Constants that are commonly used by multiple classes in different pacakges.
 * 
 * @author Ali Mehregani
 */
public class TIConstants
{
	/** 
	 * The TI agent name 
	 */
	public static final String TI_AGENT_NAME = "org.eclipse.tptp.jvmti";

	/** 
	 * The collector name 
	 */
	public static final String TI_COLLECTOR_NAME = "org.eclipse.tptp.Collector";
	
	/** 
	 * The TI data collector id 
	 */
	public static final String TI_DATA_COLLECTOR_ID = "org.eclipse.tptp.trace.jvmti.jvmtiMechanism";

	/** 
	 * Local host IP 
	 */
	public static final String LOCAL_HOST = "127.0.0.1";
		
	/** 
	 * The incremental wait times 
	 */
	public static final int INCREMENTAL_WAIT = 100;
	
	/** 
	 * The total incremental wait 
	 */
	public static final int TOTAL_WAIT = 100;
	
	/** 
	 * The attach launch configuration id 
	 */
	public static final String CONFIGURATION_ATTACH_ID = "org.eclipse.hyades.trace.ui.internal.launcher.localJavaProcess";
	
	/** 
	 * The time execution option 
	 */
	public static final String EXECUTION_TIME_ID = "org.eclipse.tptp.platform.jvmti.CGProf";
	
	/** 
	 * The name of the pull option 
	 */
	public static final String OPTION_POLL = "execdetails";
	
	/**
	 * The agent manager id
	 */
	public static final String AGNT_MGR_IID  = "org.eclipse.tptp.agentManager";
	
	/**
	 * The agent meta data command
	 */
	public static final String COMMAND_AGENT_METADATA = "getMetadata";

	/**
	 * The run command
	 */
	public static final String COMMAND_RUN = "run";
	/**
	 * The probe Insertion ID
	 */
	public static final String PROBE_INSERTION_ID = "org.eclipse.tptp.analysisType.jvmti.probe";
}