/**********************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal;

import java.util.ResourceBundle;

import org.eclipse.tptp.platform.jvmti.client.provisional.extension.CustomAnalysisProvider;
import org.eclipse.tptp.platform.jvmti.client.provisional.extension.ICustomAnalysisProvider;
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class TIPlugin extends AbstractUIPlugin {

	/* The id of this plugin */
	private static final String ID = "org.eclipse.tptp.platform.jvmti.client";
	
	//The shared instance.
	private static TIPlugin plugin;
	
	/**
	 * Contains a reference to plug-ins implementing the customAnalyisProvider
	 * extension point.
	 */
	private static ICustomAnalysisProvider[] providers;
	
	/**
	 * The constructor.
	 */
	public TIPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 *
	 * @return the shared instance.
	 */
	public static TIPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.tptp.trace.jvmti", path);
	}
	
	
	/**
	 * Returns the id of this plugin
	 * @return The id of this plugin
	 */
	public static String getId()
	{
		return ID;
	}

	/**
	 * Returns the resource string for the given key
	 * 
	 * @param key 
	 *                String, the key
	 * @return String, the resource String
	 */
	public static String getResourceString(String key) {
	try {
	    ResourceBundle resourceBundle = Platform.getResourceBundle(Platform
		    .getBundle(ID));
	    return resourceBundle.getString(key);
	} catch (Exception e) {
	    return key;
	}
    }
	
	/**
	 * Returns the providers of the customAnalysisProvider extension point.
	 */
	public static ICustomAnalysisProvider[] getProviders() {
		if(providers == null)
			providers = CustomAnalysisProvider.getContributors();
		
		return providers;
	}
}
