/*****************************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Vitaly A. Provodin, Intel - Initial API and implementation
 *
 * $Id: RunGCActionDelegate.java,v 1.4 2008/02/28 03:12:00 jkubasta Exp $
 *****************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.actions;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIDelegateHelper;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class RunGCActionDelegate extends AbstractListenerActionDelegate {

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.trace.ui.actions.AbstractProfileActionDelegate#doAction(java.lang.Object)
     */
    public void doAction(Object element) throws Exception {
		if (element instanceof TRCAgentProxy) {
		    run((TRCAgentProxy) element);
		}
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.trace.ui.actions.AbstractProfileActionDelegate#isEnabledFor(java.lang.Object)
     */
    public boolean isEnabledFor(Object element) {
		TRCAgentProxy agent;
	
		if (element instanceof TRCAgentProxy) {
		    agent = (TRCAgentProxy) element;
		    return isEnabledFor(agent);
	
		} else if (element instanceof TRCProcessProxy) {
		    EList agents = ((TRCProcessProxy) element).getAgentProxies();
		    for (Iterator i = agents.iterator(); i.hasNext();) {
				agent = (TRCAgentProxy) i.next();
				if (agent.eIsProxy()) {
				    continue;
				}
				if (isEnabledFor(agent)) {
				    return true;
				}
		    }
		}
	
		return false;
    }

    private boolean isEnabledFor(TRCAgentProxy agent) {
    	return (agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) &&
    			agent.isMonitored());
    }

    private void run(TRCAgentProxy trcAgent) throws InactiveAgentException,
    	NotConnectedException {

		if (!trcAgent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE)) {
			return;
		}
		
		if (!trcAgent.isMonitored()) {
		    MessageDialog
			    .openInformation(
				    UIPlugin.getActiveWorkbenchShell(),
				    UIPlugin
					    .getResourceString(CommonUITraceMessages.TRC_MSGT),
				    UIPlugin
					    .getResourceString(TIMessages.ERROR_RUN_GC));
		    return;
		}
		
		IAgentController agentController = null;
		ICollector agentInstance = null;
		TRCNode trcNode = trcAgent.getProcessProxy().getNode();
		
		try
		{
			agentController = AgentControllerDelegate.getInstance().getConnection(trcNode.getName(), trcNode.getPort());
		} 
		catch (Exception e)
		{			
			LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE,
					NLS.bind(TIMessages.ERROR_TI_AC_UNAVAILABLE, String.valueOf(trcNode.getPort())), e);
			return;
		}
		
		if (agentController != null) {
			agentInstance = TIDelegateHelper.locateTIAgent(agentController, trcAgent.getProcessProxy().getPid());
		}
		
		if (agentInstance instanceof IAgent) {
			((IAgent) agentInstance).sendCommand("<RunGC iid=\"org.eclipse.tptp.jvmti\"/></RunGC>",
					new ICommandHandler() {
				    	public void incomingCommand(INode node,ICommandElement command) {
				    		// do nothing
				   		}
					}
			);
		}

    }
}



