/*****************************************************************************
 * Copyright (c) 2007, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Vitaly A. Provodin, Intel - Initial API and implementation
 *
 * $Id: TIHeapAnalysisConfig.java,v 1.7 2010/07/20 20:18:55 jcayne Exp $
 *****************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.provisional.extension.ICustomAnalysisProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.PIMemoryAnalysisConf.MemoryConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;

public class TIHeapAnalysisConfig extends AbstractConfiguration {

    public TIHeapAnalysisConfig() {
	super(new Class[] { TIHeapAnalysisOpt.class });
    }

    /**
     * The heap analysis options are displayed in this configuration page.
     */
    public static class TIHeapAnalysisOpt extends MemoryConfigurationPage {

	/** The heap analysis UI */
	private TIHeapAnalysisUI execHeapAnalysisUI;

	/**
	 * Indicates whether object allocation site information should be
	 * collected
	 */
	private boolean collectObjectAllocationSite;
	
	/**
	 * Contains a reference to plug-ins implementing the customAnalyisProvider
	 * extension point.
	 */
	private ICustomAnalysisProvider[] providers;
	
	private boolean controlsCreated;

	public TIHeapAnalysisOpt() {
	    execHeapAnalysisUI = new TIHeapAnalysisUI();
	    providers = TIPlugin.getProviders();
	    // Provides the UI with the same set of providers used by the configuration.
	    execHeapAnalysisUI.setProviders(providers);
	}

	public void reset(ILaunchConfiguration launchConfiguration) {
	    try {
		collectObjectAllocationSite = launchConfiguration
			.getAttribute(
				ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE,
				false);
			if(providers != null) {
				for (int provider = 0; provider < providers.length; provider++) {
					providers[provider].resetAttribute(launchConfiguration);
				}
			}

	    } catch (CoreException e) {
		LauncherUtility.openErrorWithDetail(
			LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE,
			TIMessages.ERROR_TI_CONFIGURATION_RESET, e);
	    }
	}

	public Vector getAttributes() {
	    Vector options = null;
	    options = new Vector();

	    options.add(new DataCollectionEngineAttribute(
		    ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE,
		    String.valueOf(collectObjectAllocationSite)));
	    
	    if(providers != null) {
	    	for(int provider = 0; provider < providers.length; provider++) {
	    		DataCollectionEngineAttribute additionalOption = providers[provider].getAttribute();
	    		if(additionalOption != null)
	    			options.add(additionalOption);
	    	}
	    }

	    // FIXME collect all objects by default
		options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_HEAP_COLLECT_INSTANCE, Options.OPTION_VALUE_TRUE));
	    return options;
	}

	public boolean storeAttributes(
		ILaunchConfigurationWorkingCopy configurationWC) {

	    if (controlsCreated) {
		collectObjectAllocationSite = execHeapAnalysisUI
			.isCollectObjectAllocationSiteSelected();
	    }

	    configurationWC.setAttribute(
		    ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE,
		    collectObjectAllocationSite);
	    
	    if(providers != null) {
	    	for(int provider = 0; provider < providers.length; provider++) {
	    		// If the controls exist, update the analysis attribute based on the selection
	    		if(controlsCreated)
	    			providers[provider].updateAnalysisOption();
	    		configurationWC.setAttribute(providers[provider].getLaunchConfigurationAttribute(), providers[provider].getCollectAnalysisOption());
	    	}
	    }

	    // FIXME collect all objects by default
	    configurationWC.setAttribute(
		    ITILaunchConfigurationConstants.ATTR_HEAP_COLLECT_INSTANCE,
		    true);
	    return true;

	}

	public void createControl(Composite parent) {
		controlsCreated = true;
	    execHeapAnalysisUI.createControl(parent);
	    execHeapAnalysisUI
		    .setCollectObjectAllocationSite(collectObjectAllocationSite);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.tptp.trace.ui.internal.launcher.application.PIMemoryAnalysisConf.MemoryConfigurationPage#getDescription()
	 */
	public String getDescription() {
	    String desc = TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_HEAP_DESC");
	    return desc;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.tptp.trace.ui.internal.launcher.application.PIMemoryAnalysisConf.MemoryConfigurationPage#getTitle()
	 */
	public String getTitle() {
	    String title = TIPlugin
		    .getResourceString("JVMTI_ANALYSIS_TYPE_HEAP_NAME");
	    return title;
	}
    }
}
