/*****************************************************************************
 * Copyright (c) 2008, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Vitaly A. Provodin, Intel - Initial API and implementation
 *
 * $Id: TIHeapAnalysisUI.java,v 1.4 2010/07/20 20:18:55 jcayne Exp $
 *****************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.provisional.extension.ICustomAnalysisProvider;

public class TIHeapAnalysisUI {

    /** Object allocation site option */
    private Button collectObjectAllocationSite;
    
    /**
	 * Contains a reference to plug-ins implementing the customAnalyisProvider
	 * extension point.
	 */
    private ICustomAnalysisProvider[] providers = null;
    
    /**
     * Stores the providers implementing the customAnalysisProvider extension point.
     */
    public void setProviders(ICustomAnalysisProvider[] providers) {
    	this.providers = providers;
    }
    
    public void createControl(Composite parent) {
	/* Create the level of detail group */
	createLevelOfDetailGroup(parent);
    }

    private void createLevelOfDetailGroup(Composite parent) {
    	Group grp = createGroup(parent, TIMessages.EXEC_LEVEL_OF_DETAIL);

		GridLayout gridLayout = new GridLayout();
		gridLayout.marginBottom = 10;	
    	grp.setLayout(gridLayout);
		
    	collectObjectAllocationSite = createButton(grp,
    			TIMessages.EXEC_COLLECT_OBJECT_ALLOCATION, SWT.CHECK);
    	
    	collectObjectAllocationSite.setToolTipText(TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_HEAP_OBJ_ALLOC_DESC"));
    
    	if(providers != null) {
    		for(int provider = 0; provider < providers.length; provider++) {
    			providers[provider].createAnalysisButton(createButton(grp, providers[provider].getButtonName(), SWT.CHECK));
    		}
    	}
    }

    private Group createGroup(Composite parent, String name) {
	Group grp = new Group(parent, SWT.NONE);
	grp.setLayout(new GridLayout());
	grp.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, true, true));
	grp.setText(name);

	return grp;
    }

    private Button createButton(Composite parent, String name, int style) {
	Button button = new Button(parent, style);
	button.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, true, false));
	button.setText(name);

	return button;
    }

    /**
     * @return the collectCPUTime
     */
    public boolean isCollectObjectAllocationSiteSelected() {
	return collectObjectAllocationSite == null
		|| collectObjectAllocationSite.isDisposed() ? false
		: collectObjectAllocationSite.getSelection();
    }

    /**
     * @param collectCPUTime
     *                the collectCPUTime to set
     */
    public void setCollectObjectAllocationSite(boolean collectObjectAllocation) {
	this.collectObjectAllocationSite.setSelection(collectObjectAllocation);
    }
}
