/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 * @author ldancy
 **********************************************************************/

package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.analysistypes.TIProbeInsertionConfPage.ProbeInsertionConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;

/**
 * A class to keep track of the Profiling Launch Configuration type
 * It is meant to extend AbstractConfiguration.
 * 
 * @author ldancy
 *
 */
public class TIProbeInsertionAnalysisConfig extends AbstractConfiguration
{
	
	 public  TIProbeInsertionAnalysisConfig() 
	 {
			super(new Class[] { TIProbeInsertionAnalysisOpt.class });		
	 }

	 public static class TIProbeInsertionAnalysisOpt extends ProbeInsertionConfigurationPage
	 {
		private  TIProbeInsertionAnalysisUI probeUI ;
		// the wokring copy of the Edit Options page
		private ILaunchConfiguration launchConfiguration;
		// the launch configuration
		
		
			public TIProbeInsertionAnalysisOpt()
			{
				probeUI = new TIProbeInsertionAnalysisUI(); 
			}
			 public void reset(ILaunchConfiguration launchConfiguration)
			{
					this.launchConfiguration = launchConfiguration;
					
			}
			 /**
			  * Calls the shared method createControl. This creates the
			  * same Look and Feel for both the JVMPI and the JVMTI
			  * Edit Options page and reads info from the same
			  * place to reduce cloning.
			  */
			public void createControl(Composite parent)
			{
				try{
				probeUI.createControl(parent);
				
				}
				catch(Exception e)
				{
					//we can ignore Exceptions here 
				}
			}
			
			
			
			
		}	
		
}


