/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 * @author ldancy
 **********************************************************************/


package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchUI;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;

	/**
	 * The Probe Insertion Analysis Type UI class for JVMTI
	 * 
	 * @author ldancy
	 *
	 */
	public class TIProbeInsertionAnalysisUI 
	{
		private static ProbekitLaunchUI probeUI = new ProbekitLaunchUI();
		// we keep a reference to the Edit Options page so we
		// can constantly monitor the state to make sure the launch
		// configuration as a whole is valid
		
		/**
		 * A call to the createControl method of the probeUI. This creates the UI
		 * for the Edit Options Dialog which displays to the user the possible probes for selection
		 */
		public Composite createControl (Composite parent)
		{
		 return probeUI.CreateControl(parent, null, false);
		}
		
		/**
		 * Returns the launch configuration attrributes associated with this
		 * Probe or set of probes
		 * @return - Vector of the set of attribites we wish to store
		 */
		public Vector getAttributes()
		{
			Vector attributes = new Vector();
			int iCheckedCount = 0;
			if (probeUI.getProbeSets()!=null &&! probeUI.getProbeSets().isDisposed())
			{
			int iNumProbeSets = probeUI.getProbeSets().getItemCount();
			if (iNumProbeSets > 0) 
			{
				TableItem[] items = probeUI.getProbeSets().getItems();
				for (int i = 0; i < iNumProbeSets; i++) 
				{
					ProbeRegistryEntry entry = (ProbeRegistryEntry) items[i]
							.getData();
					if (entry != null) 
					{
						String strValueID = entry.getId();
						ProbeLaunchConfigString probe = new ProbeLaunchConfigString();
						probe.addProbeID(strValueID);
						if (items[i].getChecked()) 
						{
							String attributeKey = ProbeLaunchConfigString.AGENT_CONFIG_NAME_PREFIX + probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX;
							
							boolean bMatchingSetFound = false;
							FilterSetElement set = probeUI.getManager()
									.getDefaultFilterSet();

							// build filter string
							ArrayList attrs = null;
							StringBuffer filterStr = new StringBuffer();
							if (set != null) 
							{
								attrs = set.getChildren();
								for (int idx = 0; idx < attrs.size(); idx++) 
								{
									FilterTableElement elem = (FilterTableElement) attrs
											.get(idx);
									filterStr.append(elem.getText());
									if (elem.getMethod().length() > 0)
										filterStr
												.append(":").append(elem.getMethod()); //$NON-NLS-1$
									filterStr
											.append(":").append(elem.getVisibility()); //$NON-NLS-1$
									filterStr.append("&"); //$NON-NLS-1$
								}
							}

							if (bMatchingSetFound) 
							{
								probe.addFilters(filterStr.toString());
							} 
							else 
							{
								// Filter set was deleted or renamed or set to null
								// to use profiling filters
								probe.useDefaultFilters();
							}
							String strName = ProbeLaunchConfigString.LAUNCH_CONFIG_NAME_PREFIX
									+ probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX
									+ iCheckedCount;
							String strValueProbeLaunch = probe.toString();
							
							

							DataCollectionEngineAttribute attributeProbe = new DataCollectionEngineAttribute(
									strName, strValueProbeLaunch);
							
							attributes.add(attributeProbe);
							iCheckedCount++;
						}
					}
				}
			}
		}
			return attributes;
	}
			
			/**
			 * Here we set our own attributes to keep track of whether or not the
			 * launch configuration was valid upon exiting the Edit Options
			 * pane
			 * @param configurationWC
			 * @return
			 */
		public boolean storeAttributes (ILaunchConfigurationWorkingCopy configurationWC)
		{
			try
			{
			
			boolean probesSelected = false;
			probeUI.clearSelectedProbes();
			configurationWC.setAttribute("anyProbesSelected", false);
			//in the case where probes have been deleted between sessions, reset
			int iSelectedProbes = 0;
			int iAvailableProbes = probeUI.getProbeSets().getItemCount();
			
			if (probeUI.getProbeSets()!=null &&! probeUI.getProbeSets().isDisposed())
			{
			int iNumProbeSets = probeUI.getProbeSets().getItemCount();
			if (iNumProbeSets > 0 && iAvailableProbes >0) 
			{
				TableItem[] items = probeUI.getProbeSets().getItems();
				for (int i = 0; i < iNumProbeSets; i++) 
				{
					ProbeRegistryEntry entry = (ProbeRegistryEntry) items[i]
							.getData();
					if (entry != null) 
					{
						String strValueID = entry.getId();
						ProbeLaunchConfigString probe = new ProbeLaunchConfigString();
						probe.addProbeID(strValueID);
						if (items[i].getChecked()) 
						{
							String attributeKey = ProbeLaunchConfigString.AGENT_CONFIG_NAME_PREFIX + probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + i;
							configurationWC.setAttribute(attributeKey, probe.toString());
							
							// we add these to the Vector keeping track of the saved selections so we can
							// initialize the UI on the next open
							probeUI.addSelectedProbes(probe.toString());
							iSelectedProbes++;
						}
						// Otherwise, we need to reset the attribute with an empty value to make sure
						// the most recent state of the Edit Options UI is represented
						else
						{
							String attributeKey = ProbeLaunchConfigString.AGENT_CONFIG_NAME_PREFIX + probeUI.PROBE_LAUNCH_UNIQUE_PROBESPEC_SUFFIX + i;
							configurationWC.setAttribute(attributeKey, " ");
							
						}
					}
				}
			
				if (iAvailableProbes == 0 || iSelectedProbes == 0) 
				{
					// create a new attribute to keep track of whether any probes have 
					//been selected for insertion or not
					configurationWC.setAttribute("anyProbesSelected",false);
					return probesSelected;
				} 
				else 
				{
					// this will be retrieved by validateConfiguration
					// if there are no probes selected the Profile button will be disabled
					// and an approprite error message will be displayed
					configurationWC.setAttribute("anyProbesSelected", true);
					probesSelected = true;
					String executableParameters = probeUI.getVMArguments(configurationWC);
					configurationWC.setAttribute("executableArgs", executableParameters);
					
				}
	
			}
			
		}
			return probesSelected;
				
			}
			catch(Exception e){
				return true;
			}
			
		}
	}
