/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 * @author ldancy
 **********************************************************************/

package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.Vector;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

/**
 * The parent class for the Probekit Launch Configuration with JVMTI
 * It is meant to house the methods which are JVMTI specific and require
 * reference to the Analysis Type used in JVMTI as opposed to the
 * IProfilingType used in JVMPI
 * @author valentina
 *
 */
public class TIProbeInsertionConfPage extends AbstractConfiguration
{	
	/**
	 * Constructor - Add the execution time configuration page
	 */
	public TIProbeInsertionConfPage()
	{
		super(new Class[] {ProbeInsertionConfigurationPage.class});
	}

	/**
	 * The probe insertion configuration page.
	 * 
	 * @author Liz Dancy
	 */
	public static class ProbeInsertionConfigurationPage extends ExtendedConfigurationPage
	{
		private ILaunchConfiguration launchConfiguration;
		public TIProbeInsertionAnalysisUI pr;
		
		public ProbeInsertionConfigurationPage()
		{
			pr = new TIProbeInsertionAnalysisUI(); 
		}
		
		public ImageDescriptor getWizardBanner()
		{
			return TraceUIImages.INSTANCE.getImageDescriptor(TraceUIImages.IMG_PROF_SET_WIZ_BAN);
		}
		
		public void addErrorListener(final IStatusListener statusListener)
		{
			//TODO: once the backend is in and we know which errors we will need
		}
		/*
		 * Returns the title of the page
		 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage#getTitle()
		 */
		public String getTitle()
		{
			 String title = TraceMessages.HPF_T;
			return title;
		}
		
		public void reset(ILaunchConfiguration launchConfiguration)
		{
			this.launchConfiguration = launchConfiguration;
			
		}
		/**
		 * Returns the name of this configuration page
		 */
		public String getPageName()
		{
			return this.getClass().getName();
		}
		/**
		 * Return the description associated with this configuration page. 
		 * This may eventually move out to the ProbekitLaunchUI
		 * getDescription().
		 */
		public String getDescription()
		{
			// to keep the same LAF as the JVMPI probe analysis description
		return  LauncherMessages.CONFIGURATION_PROFILING_TYPE_DESC;
		}
		
		/**
		 * Critical in saving the configuration of the Edit Options
		 * page and also allows us to store attributes and refer to them
		 * later to validate the launch configuration
		 */
		public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC)
		{
		
			return pr.storeAttributes(configurationWC);    
		}
		/**
		 * Calls the JVMTI-specific getAttributes()method
		 */
		public Vector getAttributes()
		{
			
			return pr.getAttributes();
		}

		public void createControl(Composite parent)
		{
			pr.createControl(parent);
		}
		
	}
}
