/*****************************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: TIThreadAnalysisConfig.java,v 1.1 2008/02/28 12:50:06 ialelekov Exp $
 *****************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.PIMemoryAnalysisConf.MemoryConfigurationPage;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;

public class TIThreadAnalysisConfig extends AbstractConfiguration {
    public TIThreadAnalysisConfig() {
    	super(new Class[] { TIThreadAnalysisOpt.class });
    }

    /**
     * The threads analysis options are displayed in this configuration page.
     */
    public static class TIThreadAnalysisOpt extends MemoryConfigurationPage {
    	/** The threads analysis UI */
    	private TIThreadAnalysisUI threadAnalysisUI;

    	/**
    	 * Indicates whether contention analysis information should be collected
    	 */
    	private boolean contentionAnalysis;
    	private boolean controlsCreated;

    	public TIThreadAnalysisOpt() {
    		contentionAnalysis = false;
    		threadAnalysisUI = new TIThreadAnalysisUI();
    	}

    	public void reset(ILaunchConfiguration launchConfiguration) {
    		try {
    			contentionAnalysis = 
    				launchConfiguration.getAttribute(
    					ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS, false);
    		} catch (CoreException e) {
    			LauncherUtility.openErrorWithDetail(
    					LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE,
    						TIMessages.ERROR_TI_CONFIGURATION_RESET, e);
    		}
    	}

    	public Vector getAttributes() {
    		if (controlsCreated) 
    			contentionAnalysis = threadAnalysisUI.getContentionAnalysis();

    		Vector options = new Vector();
    		options.add(new DataCollectionEngineAttribute(
    				ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS,
    				String.valueOf(contentionAnalysis)));

    		return options;
    	}

    	public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
    		if (controlsCreated) 
    			contentionAnalysis = threadAnalysisUI.getContentionAnalysis();

    		configurationWC.setAttribute(
    				ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS,
    					contentionAnalysis);

    		return true;
    	}

    	public void createControl(Composite parent) {
    		threadAnalysisUI.createControl(parent);
    		threadAnalysisUI.setContentionAnalysis(contentionAnalysis);
    		controlsCreated = true;
    	}

    	public String getDescription() {
    		return TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_THRD_DESC");
    	}

		public String getTitle() {
			return TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_THRD_NAME");
		}
    }
}
