/*****************************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id: TIThreadAnalysisUI.java,v 1.1 2008/02/28 12:50:06 ialelekov Exp $
 *****************************************************************************/
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;

public class TIThreadAnalysisUI {
    /* Contention analysis option */
    private Button contentionAnalysisBtn;

    public void createControl(Composite parent) {
    	createLevelOfDetailGroup(parent);
    }

    private void createLevelOfDetailGroup(Composite parent) {
    	Group gr = createGroup(parent, TIMessages.EXEC_LEVEL_OF_DETAIL);

		GridLayout gridLayout = new GridLayout();
		gridLayout.marginBottom = 10;	// align with TIHeapAnalysisUI 
    	gr.setLayout(gridLayout);
		
    	contentionAnalysisBtn = 
    		createButton(gr,TIMessages.EXEC_CONTENTION_ANALYSIS, SWT.CHECK);
    }

    private Group createGroup(Composite parent, String name) {
    	Group grp = new Group(parent, SWT.NONE);
    	grp.setLayout(new GridLayout());
    	grp.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, true, true));
    	grp.setText(name);

    	return grp;
    }

    private Button createButton(Composite parent, String name, int style) {
    	Button button = new Button(parent, style);
    	button.setLayoutData(new GridData(SWT.FILL, SWT.DEFAULT, true, false));
    	button.setText(name);

    	return button;
    }

    public boolean getContentionAnalysis() {
    	return contentionAnalysisBtn != null && !contentionAnalysisBtn.isDisposed() && 
				contentionAnalysisBtn.getSelection();
    }

    public void setContentionAnalysis(boolean enabled) {
    	contentionAnalysisBtn.setSelection(enabled);
    }
}
